/*
 * Decompiled with CFR 0.152.
 */
package stallone.graph;

import stallone.api.doubles.IDoubleIterator;
import stallone.api.ints.IIntElement;
import stallone.api.ints.IIntIterator;
import stallone.ints.IntElement;

class MatrixGraphNeighborIterator
implements IIntIterator {
    private int myself;
    private IDoubleIterator it;

    public MatrixGraphNeighborIterator(int _myself, IDoubleIterator _it) {
        this.myself = _myself;
        this.it = _it;
        this.skipmyself();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public IIntElement next() {
        this.it.advance();
        return new IntElement(this.it.row(), this.it.column(), this.it.getIndex(), this.it.getIndex());
    }

    @Override
    public int get() {
        return this.it.getIndex();
    }

    @Override
    public void reset() {
        this.it.reset();
    }

    private void skipmyself() {
        if (this.it.getIndex() == this.myself) {
            this.it.advance();
        }
    }

    @Override
    public void advance() {
        this.it.advance();
        this.skipmyself();
    }

    @Override
    public int getIndex() {
        return this.it.getIndex();
    }

    @Override
    public int row() {
        return this.it.row();
    }

    @Override
    public int column() {
        return this.it.column();
    }

    @Override
    public void set(int x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

