/*
 * Decompiled with CFR 0.152.
 */
package stallone.graph;

import java.util.Iterator;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.graph.IIntEdge;
import stallone.api.graph.IIntGraph;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.graph.MatrixGraphEdgeIterator;
import stallone.graph.MatrixGraphNeighborIterator;
import stallone.ints.IntArrayIterator;

public class MatrixIntGraph
implements IIntGraph {
    private IDoubleArray matrix;

    public MatrixIntGraph(IDoubleArray matrix) {
        this.matrix = matrix;
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Supplied matrix is not square (n x n).");
        }
    }

    @Override
    public boolean contains(int vertex) {
        return vertex >= 0 && vertex < this.matrix.rows();
    }

    @Override
    public boolean contains(int vertex1, int vertex2) {
        return this.matrix.get(vertex1, vertex2) > 0.0;
    }

    @Override
    public IIntIterator nodeIterator() {
        IntArrayIterator it = new IntArrayIterator(Ints.create.arrayRange(this.matrix.rows()));
        return it;
    }

    @Override
    public IIntIterator neighborIterator(int node) {
        IDoubleArray row = this.matrix.viewRow(node);
        return new MatrixGraphNeighborIterator(node, row.nonzeroIterator());
    }

    @Override
    public Iterator<IIntEdge> edgeIterator() {
        return new MatrixGraphEdgeIterator(this.matrix, this.matrix.nonzeroIterator());
    }

    @Override
    public int numberOfNodes() {
        return this.matrix.rows();
    }

    @Override
    public int numberOfArcs() {
        int n = 0;
        IDoubleIterator it = this.matrix.nonzeroIterator();
        while (it.hasNext()) {
            ++n;
            it.advance();
        }
        return n;
    }

    @Override
    public IIntArray getNodes() {
        return Ints.create.arrayRange(this.matrix.rows());
    }

    @Override
    public IIntArray getNeighbors(int node) {
        IIntList res = API.intsNew.list(5);
        int i = 0;
        while (i < this.matrix.columns()) {
            if (this.matrix.get(node, i) != 0.0) {
                res.append(i);
            }
            ++i;
        }
        return res;
    }
}

