/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import java.util.List;
import stallone.api.datasequence.IDataSequence;
import stallone.api.function.IParametricFunction;
import stallone.api.hmm.HMM;
import stallone.api.hmm.IExpectationMaximization;
import stallone.api.hmm.IHMM;
import stallone.api.hmm.IHMMOptimizer;
import stallone.api.hmm.IHMMParameters;
import stallone.api.hmm.ParameterEstimationException;
import stallone.api.stat.IParameterEstimator;
import stallone.doubles.PrimitiveDoubleTools;

public class EMMultiStart
implements IHMMOptimizer {
    private List<IDataSequence> obs;
    private IParametricFunction outputModel;
    private IParameterEstimator outputEstimator;
    private IHMMParameters[] initialParameters;
    private int nstates;
    private int nscansteps;
    private int nconvsteps;
    private double dectol;
    private IHMM hmmBest = null;

    public EMMultiStart(List<IDataSequence> _obs, IParametricFunction _outputModel, IParameterEstimator _outputEstimator, IHMMParameters[] _initialParameters) {
        this.obs = _obs;
        this.outputModel = _outputModel;
        this.outputEstimator = _outputEstimator;
        this.initialParameters = _initialParameters;
    }

    public void setNumberOfScanningSteps(int steps) {
        this.nscansteps = steps;
    }

    public void setNumberOfConvergenceSteps(int steps) {
        this.nconvsteps = steps;
    }

    public void setLikelihoodDecreaseTolerance(double tol) {
        this.dectol = tol;
    }

    @Override
    public void run() throws ParameterEstimationException {
        double likelihoodBest = Double.NEGATIVE_INFINITY;
        IHMMOptimizer emBest = null;
        int i = 0;
        while (i < this.initialParameters.length) {
            System.out.println("SCAN " + i);
            IExpectationMaximization em = HMM.create.em(this.obs, this.outputModel, this.outputEstimator, this.initialParameters[i]);
            double[] likelihoods = null;
            try {
                em.setMaximumNumberOfStep(this.nscansteps);
                em.setLikelihoodDecreaseTolerance(this.dectol);
                em.run();
                likelihoods = em.getLogLikelihoodHistory();
                System.out.println("Likelihood history: ");
                PrimitiveDoubleTools.print(likelihoods, "\n");
                System.out.println();
                if (likelihoods[likelihoods.length - 1] > likelihoodBest) {
                    likelihoodBest = likelihoods[likelihoods.length - 1];
                    emBest = em;
                }
            }
            catch (ParameterEstimationException e) {
                System.out.println(" CAUGHT exception in EMmult (see below). Will continue with another try\n" + e);
            }
            Runtime.getRuntime().gc();
            ++i;
        }
        if (emBest == null) {
            throw new RuntimeException("Could not optimize a single model. It seems all attempts have failed. STOPPING!");
        }
        System.out.println("Refining the best model with log L = " + likelihoodBest);
        System.out.println(" and Parameters = " + emBest.getHMM().getParameters());
        System.out.println(" and likelihood = " + emBest.getHMM().getLogLikelihood());
        emBest.setMaximumNumberOfStep(this.nconvsteps);
        emBest.setLikelihoodDecreaseTolerance(this.dectol);
        emBest.run();
        double[] likelihoods = emBest.getLogLikelihoodHistory();
        PrimitiveDoubleTools.print(likelihoods, "\n");
        this.hmmBest = emBest.getHMM();
    }

    @Override
    public IHMM getHMM() {
        return this.hmmBest;
    }
}

