/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import stallone.api.API;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.hmm.IHMMParameters;
import stallone.api.io.IO;
import stallone.api.mc.MarkovModel;
import stallone.doubles.DoubleArrayTest;

public class HMMParameters
implements IHMMParameters {
    private int nstates;
    private IDoubleArray T;
    private IDoubleArray p0;
    private boolean isReversible = false;
    private boolean isStationary = true;
    private boolean fixT = false;
    private int nparameters;
    private IDoubleArray[] parOut;
    private boolean fixParOut = false;

    public HMMParameters(int _nstates, boolean _isReversible, boolean _isStationary) {
        this.nstates = _nstates;
        this.isReversible = _isReversible;
        this.isStationary = _isStationary;
        this.parOut = new IDoubleArray[_nstates];
    }

    public HMMParameters(IDoubleArray _T, IDoubleArray _p0, IDoubleArray[] _parOut, boolean _isReversible, boolean _isStationary) {
        this.T = _T;
        this.nstates = this.T.rows();
        this.p0 = _p0;
        this.isReversible = _isReversible;
        this.isStationary = _isStationary;
        this.parOut = _parOut;
        DoubleArrayTest.assertSquare(_T);
        DoubleArrayTest.assertOrder(_p0, 1);
        DoubleArrayTest.assertSize(_p0, this.nstates);
        if (_parOut.length != this.nstates) {
            throw new IllegalArgumentException("Provided with " + _parOut.length + " parameter sets but expected " + this.nstates);
        }
        this.nparameters = _parOut[0].size();
        IDoubleArray[] iDoubleArrayArray = _parOut;
        int n = _parOut.length;
        int n2 = 0;
        while (n2 < n) {
            IDoubleArray d = iDoubleArrayArray[n2];
            if (d.size() != this.nparameters) {
                throw new IllegalArgumentException("Parameter sets don't have equal dimensions");
            }
            ++n2;
        }
    }

    @Override
    public void fixTransitionMatrix(boolean ftm) {
        this.fixT = ftm;
    }

    @Override
    public void fixOutputParameters(boolean fop) {
        this.fixParOut = fop;
    }

    @Override
    public IHMMParameters copy() {
        IDoubleArray[] newOut = new IDoubleArray[this.parOut.length];
        int i = 0;
        while (i < newOut.length) {
            newOut[i] = this.parOut[i].copy();
            ++i;
        }
        return new HMMParameters(this.T.copy(), this.p0.copy(), newOut, this.isReversible, this.isStationary);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("T = \n");
        strb.append(String.valueOf(Doubles.util.toString(this.T, "\t", "\n")) + "\n");
        strb.append("pi = " + Doubles.util.toString(this.p0, ", ") + "\n");
        IDoubleArray[] iDoubleArrayArray = this.parOut;
        int n = this.parOut.length;
        int n2 = 0;
        while (n2 < n) {
            IDoubleArray d = iDoubleArrayArray[n2];
            strb.append("par = " + Doubles.util.toString(d, ", ") + "\n");
            ++n2;
        }
        return strb.toString();
    }

    @Override
    public int getNStates() {
        return this.nstates;
    }

    @Override
    public IDoubleArray getOutputParameters(int state) {
        return this.parOut[state];
    }

    @Override
    public IDoubleArray getOutputParameterMatrix() {
        double[][] res = new double[this.nstates][];
        int i = 0;
        while (i < res.length) {
            res[i] = this.parOut[i].getArray();
            ++i;
        }
        return API.doublesNew.array(res);
    }

    @Override
    public void setOutputParameters(int state, IDoubleArray par) {
        if (this.fixParOut) {
            return;
        }
        this.parOut[state] = par;
    }

    @Override
    public IDoubleArray getTransitionMatrix() {
        return this.T;
    }

    @Override
    public void setTransitionMatrix(IDoubleArray _T) {
        if (this.fixT) {
            return;
        }
        this.T = _T;
        if (this.isStationary) {
            this.p0 = MarkovModel.util.stationaryDistribution(this.T);
        }
        if (this.isReversible && !MarkovModel.util.isReversible(this.T)) {
            IO.util.error("HMM Parameters are required to be reversible, but trying to set non-reversible transition matrix: \n" + Doubles.util.toString(_T, "\t", "\n") + "\n");
        }
    }

    @Override
    public IDoubleArray getInitialDistribution() {
        return this.p0;
    }

    @Override
    public void setInitialDistribution(IDoubleArray _p0) {
        if (this.isStationary) {
            IO.util.error("HMM Parameters are set stationary, but trying to set initial distribution. This is prohibited.");
        }
        this.p0 = _p0;
    }

    @Override
    public boolean isReversible() {
        return this.isReversible;
    }

    @Override
    public boolean isStationary() {
        return this.isStationary;
    }
}

