/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;

public class MatrixPowerCache {
    IDoubleArray T1;
    IDoubleArray[] Tn;

    public MatrixPowerCache(int nmaxCache) {
        if (nmaxCache > 1000) {
            throw new IllegalArgumentException("Trying to construct a transition matrix power cache with n > 1000. This is probably not be a good idea. Stopping.");
        }
        this.Tn = new IDoubleArray[nmaxCache + 1];
    }

    public MatrixPowerCache() {
        this(100);
    }

    private void computePowers() {
        this.Tn[0] = Doubles.create.identity(this.T1.rows());
        this.Tn[1] = this.T1.copy();
        int i = 2;
        while (i < this.Tn.length) {
            this.Tn[i] = Algebra.util.product(this.Tn[i - 1], this.T1);
            ++i;
        }
    }

    public IDoubleArray getPower(IDoubleArray _T1, int n) {
        if (this.T1 != _T1) {
            this.T1 = _T1;
            this.computePowers();
        }
        if (n < this.Tn.length) {
            return this.Tn[n];
        }
        return Algebra.util.power(_T1, n);
    }

    public double getPowerElement(IDoubleArray _T1, int n, int i, int j) {
        return this.getPower(_T1, n).get(i, j);
    }
}

