/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import stallone.api.API;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.doubles.IDoubleArray;
import stallone.ints.PrimitiveIntTools;
import stallone.util.CommandLineParser;

public class ExpandEigenvectorsCmd {
    private String inDir;
    private String outDir;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringCommand("i", true);
        parser.addStringCommand("o", true);
        if (!parser.parse(args)) {
            return false;
        }
        this.inDir = parser.getString("i");
        this.outDir = parser.getString("o");
        return true;
    }

    public static String getUsageString() {
        return "\n=======================================\n ExpandEigenvectorsCmd\n=======================================\nUsage: \n\nMandatory input and output options: \n -i <input-directory>+\n\n -o <out-dir>\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        int[] lagtimes;
        ExpandEigenvectorsCmd cmd;
        if (args.length == 0) {
            System.out.println(ExpandEigenvectorsCmd.getUsageString());
            System.exit(0);
        }
        if (!(cmd = new ExpandEigenvectorsCmd()).parseArguments(args)) {
            System.out.println(ExpandEigenvectorsCmd.getUsageString());
            System.exit(0);
        }
        IDoubleArray lagFile = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-its.dat");
        int[] nArray = lagtimes = PrimitiveIntTools.from(lagFile.getColumn(0));
        int n = lagtimes.length;
        int n2 = 0;
        while (n2 < n) {
            int tau = nArray[n2];
            IDoubleArray TC = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-TC-lag" + tau + ".dat");
            IDoubleArray Pi = API.doublesNew.diag(API.msm.stationaryDistribution(TC));
            IDoubleArray Chi = API.doublesNew.fromFile(String.valueOf(cmd.inDir) + "/hmm-Chi-lag" + tau + ".dat");
            IEigenvalueDecomposition evd = API.alg.evd(TC);
            IDoubleArray R = evd.R().viewReal();
            IDoubleArray L = API.alg.inverse(R);
            IDoubleArray Lbig = API.alg.product(L, API.alg.transposeToNew(Chi));
            IDoubleArray pibig = Lbig.viewRow(0);
            API.alg.normalize(pibig, 1);
            IDoubleArray PibigInv = API.doublesNew.diag(pibig.size(), 1.0);
            int i = 0;
            while (i < pibig.size()) {
                PibigInv.set(i, i, 1.0 / pibig.get(i));
                ++i;
            }
            IDoubleArray Rbig = API.alg.product(API.alg.product(PibigInv, Chi), API.alg.product(Pi, R));
            API.io.writeString(String.valueOf(cmd.outDir) + "/hmm-pibig-lag" + tau + ".dat", API.doubles.toString(pibig, "\n", "\n"));
            API.io.writeString(String.valueOf(cmd.outDir) + "/hmm-Rbig-lag" + tau + ".dat", API.doubles.toString(Rbig, "\t", "\n"));
            ++n2;
        }
    }
}

