/*
 * Decompiled with CFR 0.152.
 */
package stallone.hmm.pmm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import stallone.api.API;
import stallone.api.datasequence.IDataSequenceLoader;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.util.CommandLineParser;

public class Validation {
    private List<String> inputFiles;
    private List<IIntArray> data;
    private int dataMaxTime = 0;
    private int nObservableStates = 0;
    private IDoubleArray T;
    private IDoubleArray pout;
    private int lagModel;
    private String outdir;
    private boolean computeAutocorrelations = true;
    private boolean computeTimescales = false;

    public boolean parseArguments(String[] args) throws FileNotFoundException, IOException {
        CommandLineParser parser = new CommandLineParser();
        parser.addStringCommand("iT", true);
        parser.addStringCommand("ipout", true);
        parser.addStringArrayCommand("idata", true);
        parser.addIntCommand("lag", true);
        parser.addStringCommand("o", true);
        parser.addCommand("autocorrelations", false);
        parser.addCommand("timescales", false);
        if (!parser.parse(args)) {
            return false;
        }
        String[] ifiles = parser.getStringArray("idata");
        this.inputFiles = new ArrayList<String>();
        int i = 0;
        while (i < ifiles.length) {
            this.inputFiles.add(ifiles[i]);
            ++i;
        }
        IDataSequenceLoader loader = API.dataNew.multiSequenceLoader(this.inputFiles);
        this.data = API.intseq.loadIntSequences(this.inputFiles);
        int i2 = 0;
        while (i2 < this.data.size()) {
            this.dataMaxTime = Math.max(this.dataMaxTime, this.data.get(i2).size());
            this.nObservableStates = Math.max(this.nObservableStates, API.ints.max(this.data.get(i2)) + 1);
            ++i2;
        }
        this.T = API.doublesNew.fromFile(parser.getString("iT"));
        this.pout = API.doublesNew.fromFile(parser.getString("ipout"));
        this.lagModel = parser.getInt("lag");
        this.outdir = parser.getString("o");
        if (parser.hasCommand("autocorrelations")) {
            this.computeAutocorrelations = true;
            this.computeTimescales = false;
        }
        if (parser.hasCommand("timescales")) {
            this.computeAutocorrelations = false;
            this.computeTimescales = true;
        }
        return true;
    }

    public static String getUsageString() {
        return "\n=======================================\n Validation\n=======================================\nUsage: \nMandatory input and output options:  -iT <T-macro> +\n -ipout <output-matrix> +\n -idata  <discrete trajectory>+\n -lag <lag of model>\n[-o [<output-directory>]]\n\nMode selection (either of): [-autocorrelations]\n[-timescales]\n\n";
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Validation cmd = new Validation();
        if (args.length == 0) {
            System.out.println(Validation.getUsageString());
            System.exit(0);
        }
        if (!cmd.parseArguments(args)) {
            System.out.println(Validation.getUsageString());
            System.exit(0);
        }
        IDoubleArray poutT = API.alg.transposeToNew(cmd.pout);
        String prefix = "validate-corr-";
        int nout = cmd.nObservableStates;
        if (cmd.computeTimescales) {
            nout = cmd.T.rows() - 1;
            prefix = "validate-its-";
        }
        PrintStream[] out = new PrintStream[nout];
        int i = 0;
        while (i < nout) {
            out[i] = new PrintStream(String.valueOf(cmd.outdir) + "/" + prefix + (i + 1) + ".out");
            out[i].println("# data\tmodel");
            ++i;
        }
        int maxlag = cmd.dataMaxTime / (2 * cmd.lagModel);
        int tauModel = 1;
        while (tauModel <= maxlag) {
            int tauData = cmd.lagModel * tauModel;
            IDoubleArray Cdata = API.msm.estimateC(cmd.data, tauData);
            IDoubleArray Tdata = API.msm.estimateT(Cdata);
            IDoubleArray Tn = API.alg.power(cmd.T, tauModel);
            IDoubleArray pimodel = API.msm.stationaryDistribution(Tn);
            IDoubleArray corrn = API.alg.product(API.doublesNew.diag(pimodel), Tn);
            IDoubleArray corrmodel = API.alg.product(API.alg.product(poutT, corrn), cmd.pout);
            if (cmd.computeAutocorrelations) {
                IDoubleArray pidata = API.msm.stationaryDistribution(Tdata);
                IDoubleArray corrdata = API.alg.product(API.doublesNew.diag(pidata), Tdata);
                int i2 = 0;
                while (i2 < nout) {
                    out[i2].println(String.valueOf(corrdata.get(i2, i2)) + "\t" + corrmodel.get(i2, i2));
                    ++i2;
                }
            } else if (cmd.computeTimescales) {
                IDoubleArray timescalesData = API.msm.timescales(Tdata, tauData);
                IDoubleArray TmodelApparent = API.msm.estimateT(corrmodel);
                IDoubleArray timescalesModel = API.msm.timescales(TmodelApparent, tauData);
                int i3 = 0;
                while (i3 < nout) {
                    out[i3].println(String.valueOf(timescalesData.get(i3)) + "\t" + timescalesModel.get(i3));
                    ++i3;
                }
            }
            ++tauModel;
        }
        int i4 = 0;
        while (i4 < nout) {
            out[i4].close();
            ++i4;
        }
    }
}

