/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.ints.IntArrayIterator;
import stallone.ints.IntArrayNonzeroIterator;
import stallone.ints.IntArrayView;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class ForeignBufferIntArray
implements IIntArray {
    private int rows;
    private int cols;
    private IntBuffer buff;

    private ForeignBufferIntArray() {
    }

    public ForeignBufferIntArray(ByteBuffer bb, int rows, int cols) {
        if (bb.capacity() / 32 < rows * cols / 32) {
            throw new OutOfMemoryError("byte buffer does not hold enough memory (" + bb.capacity() / 32 + ") to store " + rows * cols + " elements.");
        }
        bb.order(ByteOrder.nativeOrder());
        this.rows = rows;
        this.cols = cols;
        this.buff = bb.asIntBuffer();
    }

    @Override
    public int size() {
        return this.buff.capacity() / 32;
    }

    @Override
    public int order() {
        int order = 0;
        if (this.rows() > 1) {
            ++order;
        }
        if (this.columns() > 1) {
            ++order;
        }
        return order;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public int get(int i) {
        return this.buff.get(i);
    }

    @Override
    public int get(int i, int j) {
        try {
            if (this.cols == 1 && j == 0) {
                return this.buff.get(i);
            }
            if (this.rows == 1 && i == 0) {
                return this.buff.get(j);
            }
            return this.buff.get(i * this.cols + j);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error:Trying to access element (" + i + "," + j + ") in a (" + this.rows + "," + this.cols + ") array");
        }
    }

    @Override
    public void set(int i, int x) {
        this.buff.put(i, x);
    }

    @Override
    public void set(int i, int j, int x) {
        try {
            if (this.cols == 1 && j == 0) {
                this.buff.put(i, x);
            } else if (this.rows == 1 && i == 0) {
                this.buff.put(j, x);
            } else {
                int index = i * this.cols + j;
                assert (i <= this.rows && j <= this.cols);
                assert (index % 64 == 0);
                this.buff.put(index, x);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error:Trying to access element (" + i + "," + j + ") in a (" + this.rows + "," + this.cols + ") array");
        }
    }

    @Override
    public int[] getArray() {
        if (this.buff.hasArray()) {
            return this.buff.array();
        }
        int size = this.size();
        int[] res = new int[size];
        int i = 0;
        while (i < size) {
            res[i] = this.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public int[][] getTable() {
        int nrows = this.rows();
        int ncols = this.columns();
        int[][] res = new int[nrows][ncols];
        int i = 0;
        while (i < nrows) {
            int j = 0;
            while (j < ncols) {
                res[i][j] = this.get(i, j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public int[] getRow(int row) {
        int ncols = this.columns();
        int[] res = new int[ncols];
        int i = 0;
        while (i < ncols) {
            res[i] = this.get(row, i);
            ++i;
        }
        return res;
    }

    @Override
    public IIntArray viewRow(int i) {
        return new IntArrayView(this, i, 0, i + 1, this.columns());
    }

    @Override
    public int[] getColumn(int col) {
        int nrows = this.rows();
        int[] res = new int[nrows];
        int i = 0;
        while (i < nrows) {
            res[i] = this.get(i, col);
            ++i;
        }
        return res;
    }

    @Override
    public IIntArray viewColumn(int j) {
        return new IntArrayView(this, 0, j, this.rows(), j + 1);
    }

    @Override
    public IIntIterator iterator() {
        return new IntArrayIterator(this);
    }

    @Override
    public IIntIterator nonzeroIterator() {
        return new IntArrayNonzeroIterator(this);
    }

    @Override
    public IIntArray copy() {
        Unsafe unsafe;
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            Method m = Unsafe.class.getDeclaredMethod("copyMemory", new Class[0]);
            f.setAccessible(true);
            m.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        ByteBuffer clone = ByteBuffer.allocateDirect(this.buff.capacity());
        long src = ((DirectBuffer)((Object)this.buff)).address();
        long dst = ((DirectBuffer)((Object)clone)).address();
        unsafe.copyMemory(src, dst, this.buff.capacity());
        return new ForeignBufferIntArray(clone, this.rows, this.cols);
    }

    @Override
    public void copyFrom(IIntArray other) {
        int size = this.size();
        if (size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < size) {
            this.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public void copyInto(IIntArray other) {
        int size = this.size();
        if (size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < size) {
            other.set(i, this.get(i));
            ++i;
        }
    }

    @Override
    public IIntArray create(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(64 * size);
        return new ForeignBufferIntArray(bb, 1, size);
    }

    @Override
    public IIntArray create(int rows, int columns) {
        ByteBuffer bb = ByteBuffer.allocateDirect(64 * rows * this.cols);
        return new ForeignBufferIntArray(bb, rows, this.cols);
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

