/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.ints.IntTableIterator;
import stallone.ints.IntTableNonzeroIterator;
import stallone.ints.PrimitiveIntTable;

public class IntArrayView
implements IIntArray {
    private IIntArray data;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int nrows;
    private int ncols;
    private int size;

    public IntArrayView(IIntArray _data, int _top, int _left, int _bottom, int _right) {
        this.data = _data;
        this.setView(_top, _left, _bottom, _right);
    }

    public IntArrayView(IIntArray _data, int _from, int _to) {
        if (_data.order() > 1) {
            throw new IllegalArgumentException("Cannot use order-1 array view constructor for a table");
        }
        this.data = _data;
        this.setView(_from, _to);
    }

    public final void setView(int _top, int _left, int _bottom, int _right) {
        this.left = _left;
        this.top = _top;
        this.right = _right;
        this.bottom = _bottom;
        this.nrows = _bottom - _top;
        this.ncols = _right - _left;
        this.size = this.nrows * this.ncols;
    }

    public final void setView(int _from, int _to) {
        if (this.data.order() > 1) {
            throw new IllegalArgumentException("Cannot use order-1 array view constructor for a table");
        }
        this.top = _from;
        this.bottom = _to;
        this.left = 0;
        this.right = 1;
        this.nrows = _to - _from;
        this.ncols = 1;
        this.size = this.nrows;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int order() {
        int order = 0;
        if (this.nrows > 1) {
            ++order;
        }
        if (this.ncols > 1) {
            ++order;
        }
        return order;
    }

    @Override
    public int rows() {
        return this.nrows;
    }

    @Override
    public int columns() {
        return this.ncols;
    }

    @Override
    public int get(int i) {
        return this.data.get(i / this.ncols, i % this.ncols);
    }

    @Override
    public int get(int i, int j) {
        return this.data.get(i - this.top, j - this.left);
    }

    @Override
    public void set(int i, int x) {
        this.data.set(i / this.ncols, i % this.ncols, x);
    }

    @Override
    public void set(int i, int j, int x) {
        this.data.set(i - this.top, j - this.left, x);
    }

    @Override
    public int[] getArray() {
        int[] res = new int[this.size];
        int i = 0;
        while (i < this.size) {
            res[i] = this.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public int[][] getTable() {
        int[][] res = new int[this.nrows][this.ncols];
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                res[i][j] = this.get(i, j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public int[] getRow(int row) {
        int[] res = new int[this.ncols];
        int i = 0;
        while (i < this.ncols) {
            res[i] = this.get(row, i);
            ++i;
        }
        return res;
    }

    @Override
    public IIntArray viewRow(int i) {
        return new IntArrayView(this, i, 0, i + 1, this.ncols);
    }

    @Override
    public int[] getColumn(int col) {
        int[] res = new int[this.nrows];
        int i = 0;
        while (i < this.nrows) {
            res[i] = this.get(i, col);
            ++i;
        }
        return res;
    }

    @Override
    public IIntArray viewColumn(int j) {
        return new IntArrayView(this, 0, j, this.nrows, j + 1);
    }

    @Override
    public IIntIterator iterator() {
        return new IntTableIterator(this);
    }

    @Override
    public IIntIterator nonzeroIterator() {
        return new IntTableNonzeroIterator(this);
    }

    @Override
    public IIntArray copy() {
        return new PrimitiveIntTable(this.getTable());
    }

    @Override
    public void copyFrom(IIntArray other) {
        if (this.size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + this.size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < this.size) {
            this.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public void copyInto(IIntArray other) {
        if (this.size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + this.size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < this.size) {
            other.set(i, this.get(i));
            ++i;
        }
    }

    @Override
    public IIntArray create(int size) {
        return this.data.create(size);
    }

    @Override
    public IIntArray create(int rows, int columns) {
        return this.data.create(rows, columns);
    }

    @Override
    public boolean isSparse() {
        return this.data.isSparse();
    }
}

