/*
 * Decompiled with CFR 0.152.
 */
package stallone.ints;

import java.io.IOException;
import java.util.StringTokenizer;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.util.StringTools;

public class IntIO {
    public static void print(IIntArray arr, String del, Appendable app) {
        IntIO.print(arr, "", del, app);
    }

    public static void print(IIntArray arr, String del, int predig, int postdig, Appendable app) {
        IntIO.print(arr, "", del, predig, postdig, app);
    }

    public static String toString(IIntArray arr, String del) {
        StringBuilder strb = new StringBuilder();
        IntIO.print(arr, ", ", strb);
        return strb.toString();
    }

    public static void print(IIntArray arr, String del) {
        IntIO.print(arr, del, System.out);
    }

    public static String toString(IIntArray arr, String del, int predig, int postdig) {
        StringBuilder strb = new StringBuilder();
        IntIO.print(arr, del, predig, postdig, strb);
        return strb.toString();
    }

    public static void print(IIntArray arr, String del, int predig, int postdig) {
        IntIO.print(arr, del, predig, postdig, System.out);
    }

    public static IIntArray readDoubleArray(String str, String delimiters) {
        StringTokenizer tok = new StringTokenizer(str, delimiters);
        int n = tok.countTokens();
        IIntArray res = Ints.create.array(n);
        int k = 0;
        while (tok.hasMoreTokens()) {
            res.set(k++, StringTools.toInt(tok.nextToken()));
        }
        return res;
    }

    public static IIntArray readDoubleArray(String str) {
        return IntIO.readDoubleArray(str, " ,;\t\n");
    }

    public static void print(IIntArray arr, String coldel, String linedel, Appendable app) {
        try {
            int i = 0;
            while (i < arr.rows()) {
                int j = 0;
                while (j < arr.columns()) {
                    app.append(String.valueOf(arr.get(i, j)));
                    app.append(coldel);
                    ++j;
                }
                app.append(linedel);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void print(IIntArray arr, String coldel, String linedel, int predig, int postdig, Appendable app) {
        try {
            int i = 0;
            while (i < arr.rows()) {
                int j = 0;
                while (j < arr.columns()) {
                    app.append(StringTools.toPrecision(arr.get(i, j), predig, postdig));
                    app.append(coldel);
                    ++j;
                }
                app.append(linedel);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static String toString(IIntArray arr) {
        if (arr.order() <= 1) {
            return IntIO.toString(arr, ", ");
        }
        if (arr.order() == 2) {
            return IntIO.toString(arr, ", ", "\n");
        }
        throw new RuntimeException("Trying to print array with order " + arr.order() + ". Currently not implemented");
    }

    public static void print(IIntArray arr, Appendable out) {
        if (arr.order() <= 1) {
            IntIO.print(arr, ", ", out);
        }
        if (arr.order() == 2) {
            IntIO.print(arr, ", ", "\n", out);
        }
        throw new RuntimeException("Trying to print array with order " + arr.order() + ". Currently not implemented");
    }

    public static void print(IIntArray arr) {
        IntIO.print(arr, System.out);
    }

    public static String toString(IIntArray arr, String coldel, String linedel) {
        StringBuilder strbuf = new StringBuilder();
        IntIO.print(arr, coldel, linedel, strbuf);
        return strbuf.toString();
    }

    public static void print(IIntArray arr, String coldel, String linedel) {
        IntIO.print(arr, coldel, linedel, System.out);
    }

    public static String toString(IIntArray arr, String coldel, String linedel, int predig, int postdig) {
        StringBuilder strbuf = new StringBuilder("");
        IntIO.print(arr, coldel, linedel, predig, postdig, strbuf);
        return strbuf.toString();
    }

    public static void print(IIntArray arr, String coldel, String linedel, int predig, int postdig) {
        IntIO.print(arr, coldel, linedel, predig, postdig, System.out);
    }
}

