/*
 * Decompiled with CFR 0.152.
 */
package stallone.intsequence;

import java.io.IOException;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.api.intsequence.IIntReader;
import stallone.api.strings.Strings;
import stallone.io.CachedAsciiFileReader;

public class IntSequenceReaderAsciiSparse
extends CachedAsciiFileReader
implements IIntReader {
    private boolean scanned = false;
    private int dimension = 0;
    private int line = 0;
    private IIntList times = Ints.create.list(0);
    private IIntList data = Ints.create.list(0);

    public IntSequenceReaderAsciiSparse() {
    }

    public IntSequenceReaderAsciiSparse(String _file) throws IOException {
        super(_file);
        this.setSource(_file);
        this.open();
    }

    @Override
    public final void setSource(String _file) {
        if (!_file.equals(this.filename)) {
            this.filename = _file;
            this.scanned = false;
        }
    }

    @Override
    public final void open() throws IOException {
        super.open();
        this.scan();
    }

    @Override
    public final void scan() throws IOException {
        if (!this.scanned) {
            this.times.clear();
            this.data.clear();
            super.scan();
            this.scanned = true;
        }
    }

    @Override
    protected boolean scanLine(String textline, int currentLineNumber) {
        String[] words = Strings.util.split(textline);
        double dtime = Strings.util.toDouble(words[0]);
        if ((double)((int)dtime) - dtime != 0.0) {
            throw new NumberFormatException("time " + dtime + " is no integer. Cannot be processed by this reader");
        }
        int val = Strings.util.toInt(words[1]);
        this.times.append((int)dtime);
        this.data.append(val);
        return words.length == 2;
    }

    @Override
    public int size() {
        int firstTime = this.times.get(0);
        int lastTime = this.times.get(this.times.size() - 1);
        return lastTime - firstTime + 1;
    }

    @Override
    public long memorySize() {
        return this.size() * 4;
    }

    @Override
    public int get(int i) {
        int j;
        int indexAt;
        if ((i -= this.times.get(0)) == (indexAt = this.times.get(j = Ints.util.locateSorted(this.times, i)))) {
            return this.data.get(j);
        }
        return this.data.get(j - 1);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IIntArray load() {
        res = Ints.create.array(this.size());
        firstTime = this.times.get(0);
        currentTime = this.times.get(0);
        lastData = this.data.get(0);
        res.set(currentTime - firstTime, lastData);
        i = 1;
        ** GOTO lbl17
        {
            res.set(currentTime - firstTime, lastData);
            ++currentTime;
            do {
                if (currentTime < this.times.get(i)) continue block0;
                if (currentTime == this.times.get(i)) {
                    lastData = this.data.get(i);
                    res.set(currentTime - firstTime, lastData);
                    ++currentTime;
                }
                ++i;
lbl17:
                // 2 sources

            } while (i < this.times.size());
        }
        return res;
    }

    public static void main(String[] args) throws IOException {
        IntSequenceReaderAsciiSparse reader = new IntSequenceReaderAsciiSparse("/Users/noe/data/my_papers/fret_nienhaus/DAse_multiple_Mg/DAse_ribozyme_0mM/tmp/hmm-4/r47_oxy_0011.path");
        reader.scan();
        int i = 0;
        while (i < reader.size()) {
            System.out.println(String.valueOf(i) + " " + reader.get(i));
            ++i;
        }
    }
}

