/*
 * Decompiled with CFR 0.152.
 */
package stallone.intsequence;

import java.io.IOException;
import java.io.PrintStream;
import stallone.api.ints.IIntArray;
import stallone.api.intsequence.IIntWriter;

public class IntSequenceWriterAsciiSparse
implements IIntWriter {
    PrintStream ps;
    boolean hasData = false;
    boolean lastDataWritten = false;
    int time = 0;
    int lastData = 0;

    public IntSequenceWriterAsciiSparse(String file) throws IOException {
        this.ps = new PrintStream(file);
    }

    @Override
    public void close() {
        if (!this.lastDataWritten) {
            this.ps.println(String.valueOf(this.time - 1) + "\t" + this.lastData);
        }
        this.ps.close();
    }

    @Override
    public void add(int data) {
        if (!this.hasData) {
            this.hasData = true;
            this.ps.println(String.valueOf(this.time) + "\t" + data);
            this.lastData = data;
            this.lastDataWritten = true;
        }
        if (data != this.lastData) {
            if (!this.lastDataWritten) {
                this.ps.println(String.valueOf(this.time - 1) + "\t" + this.lastData);
            }
            this.ps.println(String.valueOf(this.time) + "\t" + data);
            this.lastDataWritten = true;
            this.lastData = data;
        } else {
            this.lastDataWritten = false;
        }
        ++this.time;
    }

    @Override
    public void addAll(IIntArray data) {
        int i = 0;
        while (i < data.size()) {
            this.add(data.get(i));
            ++i;
        }
    }
}

