/*
 * Decompiled with CFR 0.152.
 */
package stallone.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.io.IReleasableFile;

public class NicelyCachedRandomAccessFile
implements IReleasableFile {
    private String filename;
    protected ByteBuffer pageBuffer;
    protected int pageSize;
    protected long currentPos;
    protected long pageStart;
    protected long pageEnd;
    protected RandomAccessFile randomAccessFile;
    protected FileChannel randomAccessChannel;
    protected long filesize;
    private Logger logger;

    public NicelyCachedRandomAccessFile(String _filename) throws FileNotFoundException, IOException {
        this(_filename, 8192);
    }

    public NicelyCachedRandomAccessFile(String _filename, int pageSize) throws FileNotFoundException, IOException {
        this.filename = _filename;
        this.open();
        this.logger = Logger.getLogger(NicelyCachedRandomAccessFile.class.getName());
        this.pageSize = pageSize;
        this.pageBuffer = ByteBuffer.allocate(pageSize);
        this.filesize = this.randomAccessFile.length();
        this.currentPos = 0L;
        this.pageStart = 0L;
        this.pageEnd = -1L;
    }

    public boolean fitsInBuffer(int size) throws IOException {
        if (size <= this.pageSize) {
            this.logger.log(Level.FINEST, "fitsInBuffer: enough space\n  pageEnd: " + this.pageEnd + " currentPos: " + this.currentPos + " size " + size);
            if (this.pageEnd <= this.currentPos + (long)size) {
                this.logger.log(Level.FINEST, "  Force reload via makePageAvailable.");
                this.makePageAvailable(true);
            }
            return true;
        }
        return false;
    }

    public void changePageSize(int newPageSize) throws IOException {
        this.logger.log(Level.FINEST, "changePageSize: currentPos: " + this.currentPos);
        this.pageSize = newPageSize;
        this.pageBuffer = ByteBuffer.allocate(newPageSize);
        this.makePageAvailable(true);
    }

    protected void makePageAvailable(boolean forceLoad) throws IOException {
        this.logger.log(Level.FINEST, "makePageAailable: before: pageStart: " + this.pageStart + " currentPos " + this.currentPos + " pageEnd " + this.pageEnd);
        if (this.currentPos < this.pageStart || this.pageEnd <= this.currentPos || forceLoad) {
            this.logger.log(Level.FINEST, forceLoad ? "  Reloading - forced." : "  Reloading.");
            if (this.currentPos >= this.filesize) {
                throw new IOException("Invalid position");
            }
            this.pageStart = this.currentPos;
            this.pageEnd = this.pageStart + (long)this.pageSize;
            if (this.pageEnd > this.filesize) {
                this.pageEnd = this.filesize;
            }
            this.randomAccessChannel.position(this.pageStart);
            this.pageBuffer.rewind();
            int actPageLength = (int)(this.pageEnd - this.pageStart);
            int readDataLength = this.randomAccessChannel.read(this.pageBuffer);
            this.logger.log(Level.FINEST, "  Page length wanted: " + actPageLength);
            this.logger.log(Level.FINEST, "  Data actually read: " + readDataLength);
        }
        this.pageBuffer.position((int)(this.currentPos - this.pageStart));
        this.logger.log(Level.FINEST, "makePageAailable: after: pageStart: " + this.pageStart + " currentPos " + this.currentPos + " pageEnd " + this.pageEnd);
    }

    public void seek(long pos) throws IOException {
        this.currentPos = pos;
    }

    public ByteBuffer readToBuffer(int numberOfBytes) throws IOException {
        this.makePageAvailable(false);
        this.logger.log(Level.FINE, "readToBuffer: Reading " + numberOfBytes + " bytes.");
        this.logger.log(Level.FINEST, "readToBuffer before: currentPos: " + this.currentPos + " pageStart: " + this.pageStart);
        int remaining = (int)(this.pageEnd - this.currentPos);
        if (numberOfBytes > this.pageSize) {
            throw new RuntimeException("Requesting more bytes than page size. (" + numberOfBytes + " bytes requested, " + this.pageSize + " bytes page size). " + "This seems to be a programmatic error.");
        }
        if (numberOfBytes <= remaining) {
            int inBufferPos = (int)(this.currentPos - this.pageStart);
            int savedLimit = this.pageBuffer.limit();
            this.pageBuffer.limit(inBufferPos + numberOfBytes);
            ByteBuffer retBuffer = this.pageBuffer.slice();
            this.pageBuffer.limit(savedLimit);
            this.logger.log(Level.FINEST, "  Returned buffer (Size: " + numberOfBytes + ") is " + retBuffer);
            this.logger.log(Level.FINEST, "  Read page buffer              : " + this.pageBuffer);
            this.currentPos += (long)numberOfBytes;
            this.logger.log(Level.FINEST, "readToBuffer after : currentPos: " + this.currentPos + " pageStart: " + this.pageStart);
            return retBuffer;
        }
        this.logger.log(Level.FINEST, "readToBuffer: round the corner refill.");
        ByteBuffer newRoundTheEdgeBuffer = ByteBuffer.allocate(numberOfBytes);
        int firstBlockSize = remaining;
        int secondBlockSize = numberOfBytes - remaining;
        int i = 0;
        while (i < firstBlockSize) {
            newRoundTheEdgeBuffer.put(this.pageBuffer.get());
            ++i;
        }
        this.currentPos += (long)remaining;
        this.makePageAvailable(false);
        i = 0;
        while (i < secondBlockSize) {
            newRoundTheEdgeBuffer.put(this.pageBuffer.get());
            ++i;
        }
        this.currentPos = (long)this.pageBuffer.position() + this.pageStart;
        return newRoundTheEdgeBuffer;
    }

    public int skipBytes(int n) throws IOException {
        if (this.currentPos + (long)n > this.filesize) {
            int diff = (int)(this.filesize - this.currentPos);
            this.currentPos = this.filesize;
            this.logger.log(Level.FINE, "Skipping " + n + " bytes. File limit exceeded. Current position afterwards: " + this.currentPos);
            return diff;
        }
        this.currentPos += (long)n;
        this.logger.log(Level.FINE, "Skipping " + n + " bytes. Current position afterwards: " + this.currentPos);
        return n;
    }

    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    public long getFilePointer() {
        return this.currentPos;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public void open() throws IOException {
        if (this.randomAccessChannel != null && this.randomAccessChannel.isOpen()) {
            return;
        }
        this.randomAccessFile = new RandomAccessFile(this.filename, "r");
        this.randomAccessChannel = this.randomAccessFile.getChannel();
    }

    @Override
    public String getFileName() {
        return this.filename;
    }
}

