/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.estimator;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.mc.ITransitionMatrixEstimator;

public class TransitionMatrixEstimatorNonRev
implements ITransitionMatrixEstimator {
    private IDoubleArray C;
    private IDoubleArray T;

    public TransitionMatrixEstimatorNonRev(IDoubleArray _C) {
        this.C = _C;
    }

    public TransitionMatrixEstimatorNonRev() {
    }

    @Override
    public void setCounts(IDoubleArray _C) {
        this.C = _C;
    }

    @Override
    public void estimate() {
        this.T = this.C.create(this.C.rows(), this.C.columns());
        double[] rowsums = new double[this.T.rows()];
        IDoubleIterator it = this.C.nonzeroIterator();
        while (it.hasNext()) {
            int n = it.row();
            rowsums[n] = rowsums[n] + it.get();
            it.advance();
        }
        it = this.C.nonzeroIterator();
        while (it.hasNext()) {
            this.T.set(it.row(), it.column(), it.get() / rowsums[it.row()]);
            it.advance();
        }
    }

    @Override
    public IDoubleArray getTransitionMatrix() {
        return this.T;
    }

    @Override
    public void setMaxIter(int nmax) {
    }

    @Override
    public void setConvergence(int niter) {
    }

    @Override
    public double[] getLikelihoodHistory() {
        return new double[]{API.msm.logLikelihood(this.T, this.C)};
    }
}

