/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import cern.jet.random.Beta;
import cern.jet.random.Exponential;
import cern.jet.random.Uniform;

public class ScaledElementSampler {
    public static double modePoint(double a, double b, double c, double d) {
        double s = 2.0 * (a + b + c);
        double x0 = (a + b) * d + (a + c);
        double D2 = Math.pow(x0, 2.0) - 4.0 * a * d * (a + b + c);
        return 1.0 / s * (x0 - Math.sqrt(D2));
    }

    public static double densityScaled(double x, double a, double b, double c, double d, double xm) {
        return Math.pow(x / xm, a) * Math.pow((1.0 - x) / (1.0 - xm), b) * Math.pow((d - x) / (d - xm), c);
    }

    public static double logdensityScaled(double x, double a, double b, double c, double d, double xm) {
        if (a > 1.0E-15 && b > 1.0E-15) {
            return a * (Math.log(x) - Math.log(xm)) + b * (Math.log(1.0 - x) - Math.log(1.0 - xm)) + c * (Math.log(d - x) - Math.log(d - xm));
        }
        if (a < 1.0E-15 && b > 1.0E-15) {
            return b * (Math.log(1.0 - x) - Math.log(1.0 - xm)) + c * (Math.log(d - x) - Math.log(d - xm));
        }
        if (a > 1.0E-15 && b < 1.0E-15) {
            return a * (Math.log(x) - Math.log(xm)) + c * (Math.log(d - x) - Math.log(d - xm));
        }
        return c * (Math.log(d - x) - Math.log(d - xm));
    }

    public static double logdensity(double x, double a, double b, double c, double d) {
        if (a > 1.0E-15 && b > 1.0E-15) {
            return a * Math.log(x) + b * Math.log(1.0 - x) + c * Math.log(d - x);
        }
        if (a < 1.0E-15 && b > 1.0E-15) {
            return b * Math.log(1.0 - x) + c * Math.log(d - x);
        }
        if (a > 1.0E-15 && b < 1.0E-15) {
            return a * Math.log(x) + c * Math.log(d - x);
        }
        return c * Math.log(d - x);
    }

    public static double logdensityD1(double x, double a, double b, double c, double d) {
        if (a > 1.0E-15 && b > 1.0E-15) {
            return a / x - b / (1.0 - x) - c / (d - x);
        }
        if (a < 1.0E-15 && b > 1.0E-15) {
            return -b / (1.0 - x) - c / (d - x);
        }
        if (a > 1.0E-15 && b < 1.0E-15) {
            return a / x - c / (d - x);
        }
        return -c / (d - x);
    }

    public static double logdensityD2(double x, double a, double b, double c, double d) {
        if (a > 1.0E-15 && b > 1.0E-15) {
            return -a / Math.pow(x, 2.0) - b / Math.pow(1.0 - x, 2.0) - c / Math.pow(d - x, 2.0);
        }
        if (a < 1.0E-15 && b > 1.0E-15) {
            return -b / Math.pow(1.0 - x, 2.0) - c / Math.pow(d - x, 2.0);
        }
        if (a > 1.0E-15 && b < 1.0E-15) {
            return -a / Math.pow(x, 2.0) - c / Math.pow(d - x, 2.0);
        }
        return -c / Math.pow(d - x, 2.0);
    }

    public static double sampleExponentialRestricted(Exponential randE, double upperBound) {
        boolean accept = false;
        double E = 0.0;
        while (!accept) {
            E = randE.nextDouble();
            boolean bl = accept = E <= upperBound;
        }
        return E;
    }

    public static double sampleThreePieces(Uniform randU, Exponential randE, double p1, double p2, double p3, double xl, double ql, double al, double xu, double qu, double au, double a, double b, double c, double d, double xm) {
        double X = 0.0;
        boolean accept = false;
        while (!accept) {
            double E;
            double U;
            double V = randU.nextDouble();
            if (V < p1) {
                U = randU.nextDouble();
                E = ScaledElementSampler.sampleExponentialRestricted(randE, xl * al);
                X = -E / al + xl;
                accept = Math.log(U) + ql + al * (X - xl) <= ScaledElementSampler.logdensityScaled(X, a, b, c, d, xm);
                continue;
            }
            if (V < p1 + p2) {
                U = randU.nextDouble();
                X = randU.nextDoubleFromTo(xl, xu);
                accept = Math.log(U) <= ScaledElementSampler.logdensityScaled(X, a, b, c, d, xm);
                continue;
            }
            U = randU.nextDouble();
            E = ScaledElementSampler.sampleExponentialRestricted(randE, (1.0 - xu) * -au);
            X = -E / au + xu;
            boolean bl = accept = Math.log(U) + qu + au * (X - xu) <= ScaledElementSampler.logdensityScaled(X, a, b, c, d, xm);
        }
        return X;
    }

    public static double sample(Uniform randU, Exponential randE, Beta randB, double a, double b, double c, double d) {
        double X;
        if (Math.abs(c) < 1.0E-15) {
            X = randB.nextDouble(a + 1.0, b + 1.0);
        } else if (Math.abs(d - 1.0) < 1.0E-15) {
            X = randB.nextDouble(a + 1.0, b + c + 1.0);
        } else if (c * Math.log((d - 1.0) / d) > Math.log(0.8)) {
            double U;
            do {
                U = randU.nextDouble();
                X = randB.nextDouble(a + 1.0, b + 1.0);
            } while (Math.log(U) > c * Math.log((d - X) / d));
        } else {
            double wu;
            double qu;
            double au;
            double wl;
            double ql;
            double al;
            double xu;
            double xl;
            double xm;
            if (Math.abs(a) > 1.0E-15 && Math.abs(b) > 1.0E-15) {
                xm = ScaledElementSampler.modePoint(a, b, c, d);
                double sigma = 1.0 / Math.sqrt(-ScaledElementSampler.logdensityD2(xm, a, b, c, d));
                xl = Math.max(0.0, xm - sigma);
                xu = Math.min(1.0, xm + sigma);
            } else if (Math.abs(a) > 1.0E-15 && Math.abs(b) < 1.0E-15) {
                xm = Math.min(a * d / (a + c), 1.0);
                if (xm < 1.0) {
                    double sigma = 1.0 / Math.sqrt(-ScaledElementSampler.logdensityD2(xm, a, b, c, d));
                    xl = Math.max(0.0, xm - sigma);
                    xu = Math.min(1.0, xm + sigma);
                } else {
                    xl = 1.0;
                    xu = 1.0;
                }
            } else if (Math.abs(a) < 1.0E-15 && Math.abs(b) > 1.0E-15) {
                xl = 0.0;
                xu = 0.0;
                xm = 0.0;
            } else {
                xl = 0.0;
                xu = 0.0;
                xm = 0.0;
            }
            double wm = xu - xl;
            if (xl > 0.0) {
                al = ScaledElementSampler.logdensityD1(xl, a, b, c, d);
                ql = ScaledElementSampler.logdensityScaled(xl, a, b, c, d, xm);
                wl = Math.exp(ql) / al * -1.0 * Math.expm1(-al * xl);
            } else {
                xl = 0.0;
                wl = 0.0;
                al = Double.POSITIVE_INFINITY;
                ql = Double.NEGATIVE_INFINITY;
            }
            if (xu < 1.0) {
                au = ScaledElementSampler.logdensityD1(xu, a, b, c, d);
                qu = ScaledElementSampler.logdensityScaled(xu, a, b, c, d, xm);
                wu = Math.exp(qu) / au * Math.expm1(au * (1.0 - xu));
            } else {
                xu = 1.0;
                wu = 0.0;
                au = Double.NEGATIVE_INFINITY;
                qu = Double.NEGATIVE_INFINITY;
            }
            double w = wl + wm + wu;
            double pl = wl / w;
            double pm = wm / w;
            double pu = wu / w;
            X = ScaledElementSampler.sampleThreePieces(randU, randE, pl, pm, pu, xl, ql, al, xu, qu, au, a, b, c, d, xm);
        }
        return X;
    }
}

