/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import java.util.ArrayList;
import stallone.api.doubles.IDoubleArray;
import stallone.api.potential.IEnergyModel;
import stallone.potential.AbstractPotential;

public class CompositeEnergyModel
extends AbstractPotential {
    private ArrayList<IEnergyModel> models = new ArrayList();
    private int nDIM = 0;
    private IDoubleArray coordinates;
    private double energy = 0.0;
    private IDoubleArray grad = null;

    public void add(IEnergyModel m) {
        if (!this.models.isEmpty() && m.getNDimensions() != this.nDIM) {
            throw new IllegalArgumentException("Trying to add energy model with " + m.getNDimensions() + " dimensions while expecting " + this.nDIM);
        }
        this.models.add(m);
        this.nDIM = m.getNDimensions();
    }

    @Override
    public void setCoordinates(IDoubleArray crd) {
        if (this.coordinates == null) {
            this.coordinates = crd.copy();
        } else {
            this.coordinates.copyFrom(crd);
        }
        int i = 0;
        while (i < this.models.size()) {
            this.models.get(i).setCoordinates(crd);
            ++i;
        }
    }

    @Override
    public boolean calculate() {
        this.energy = 0.0;
        this.grad = this.coordinates.copy();
        int i = 0;
        while (i < this.grad.size()) {
            this.grad.set(i, 0.0);
            ++i;
        }
        i = 0;
        while (i < this.models.size()) {
            boolean success = this.models.get(i).calculate();
            if (!success) {
                return false;
            }
            this.energy += this.models.get(i).getEnergy();
            IDoubleArray gradother = this.models.get(i).getGradient();
            int j = 0;
            while (j < this.grad.size()) {
                this.grad.set(j, this.grad.get(j) + gradother.get(j));
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getNDimensions() {
        return this.nDIM;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        return this.grad;
    }

    @Override
    public IDoubleArray getCoordinates() {
        return this.coordinates;
    }

    public int getNModels() {
        return this.models.size();
    }

    @Override
    public int getNumberOfVariables() {
        return this.models.get(0).getNDimensions();
    }
}

