/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import java.util.ArrayList;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDifferentiableMetric;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.fastutils.DoubleArrayList;
import stallone.potential.AbstractPotential;

public class HarmonicNetwork
extends AbstractPotential {
    private IDoubleArray coordinates;
    private IDifferentiableMetric<IDoubleArray> metric;
    private int natoms = 0;
    private ArrayList<int[]> bonds = new ArrayList();
    private DoubleArrayList d0 = new DoubleArrayList();
    private DoubleArrayList k = new DoubleArrayList();
    private double energy;
    private IDoubleArray gradient;

    public HarmonicNetwork(int _natoms) {
        this.natoms = _natoms;
        this.coordinates = Doubles.create.array(_natoms, 3);
        this.gradient = Doubles.create.array(_natoms, 3);
    }

    public void addSpring(int a1, int a2, double _d0, double _k) {
        this.bonds.add(new int[]{a1, a2});
        this.d0.add(_d0);
        this.k.add(_k);
    }

    public void setMetric(IDifferentiableMetric<IDoubleArray> m) {
        this.metric = m;
    }

    @Override
    public void setCoordinates(IDoubleArray _coordinates) {
        this.coordinates.copyFrom(_coordinates);
    }

    @Override
    public boolean calculate() {
        this.energy = 0.0;
        int i = 0;
        while (i < this.gradient.size()) {
            this.gradient.set(i, 0.0);
            ++i;
        }
        i = 0;
        while (i < this.bonds.size()) {
            int[] b = this.bonds.get(i);
            IDoubleArray c1 = this.coordinates.viewRow(b[0]);
            IDoubleArray c2 = this.coordinates.viewRow(b[1]);
            double d = this.metric.distance(c1, c2);
            double e = 0.5 * this.k.get(i) * (d - this.d0.get(i)) * (d - this.d0.get(i));
            this.energy += e;
            System.out.println(" b [" + b[0] + "," + b[1] + "]\t" + e);
            double fm = this.k.get(i) * (d - this.d0.get(i));
            IDoubleArray mg1 = this.metric.gradientX(c1, c2);
            int dim = 0;
            while (dim < 3) {
                this.gradient.set(b[0], dim, this.gradient.get(b[0], dim) + fm * mg1.get(dim));
                ++dim;
            }
            IDoubleArray mg2 = this.metric.gradientY(c1, c2);
            int dim2 = 0;
            while (dim2 < 3) {
                this.gradient.set(b[1], dim2, this.gradient.get(b[1], dim2) + fm * mg2.get(dim2));
                ++dim2;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getNDimensions() {
        return this.natoms * 3;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        return this.gradient;
    }

    @Override
    public IDoubleArray getCoordinates() {
        return this.coordinates;
    }

    @Override
    public int getNumberOfVariables() {
        return this.coordinates.size();
    }
}

