/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

import stallone.api.algebra.Algebra;
import stallone.api.doubles.IDoubleArray;

public class GaussianMultiVariate {
    private IDoubleArray m;
    private IDoubleArray cov;
    private double amplitude;
    private IDoubleArray covInv;

    public GaussianMultiVariate(IDoubleArray m, IDoubleArray cov) {
        this.amplitude = 1.0 / (Math.pow(Math.PI * 2, (double)m.size() / 2.0) * Math.sqrt(Algebra.util.det(cov)));
    }

    public double f(IDoubleArray x) {
        IDoubleArray dev = Algebra.util.subtract(x, this.m);
        IDoubleArray v2 = Algebra.util.product(dev, this.covInv);
        double res = Algebra.util.dot(v2, dev);
        return this.amplitude * Math.exp(-0.5 * res);
    }
}

