/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat;

public class LogFactorial {
    private int nmax;
    private double[] preCalculated;

    public LogFactorial(int _nmax) {
        this.nmax = _nmax;
        this.preCalculated = new double[_nmax + 1];
        int i = 0;
        while (i <= _nmax) {
            this.preCalculated[i] = LogFactorial.calculateNow(i);
            ++i;
        }
    }

    private static double calculateNow(int n) {
        double logfac = 0.0;
        int i = 1;
        while (i <= n) {
            logfac += Math.log(i);
            ++i;
        }
        return logfac;
    }

    public double calculate(int n) {
        if (n <= this.nmax) {
            return this.preCalculated[n];
        }
        return LogFactorial.calculateNow(n);
    }
}

