/*
 * Decompiled with CFR 0.152.
 */
package stallone.stat.modelselection;

import stallone.doubles.PrimitiveDoubleTools;
import stallone.util.MathTools;

public class ExitTimes {
    private double[] exitTimes;
    private int nExp = 1;
    private double k;
    private int n1 = 0;
    private double ksum = 0.0;
    private double a;
    private double k1;
    private double k2;
    private int n2 = 0;
    private double asum = 0.0;
    private double k1sum = 0.0;
    private double k2sum = 0.0;

    public ExitTimes(double[] _exitTimes) {
        this.exitTimes = _exitTimes;
        this.nExp = 1;
        this.k = PrimitiveDoubleTools.mean(_exitTimes);
    }

    private double logLikelihood1(double _k) {
        double res = (double)this.exitTimes.length * Math.log(_k);
        double[] dArray = this.exitTimes;
        int n = this.exitTimes.length;
        int n2 = 0;
        while (n2 < n) {
            double ti = dArray[n2];
            res -= _k * ti;
            ++n2;
        }
        return res;
    }

    private double logPrior1(double _k) {
        return -Math.log(_k);
    }

    private double logLikelihood2(double _a, double _k1, double _k2) {
        double res = (double)(-this.exitTimes.length) * Math.log(_a / _k1 + (1.0 - _a) / _k2);
        double[] dArray = this.exitTimes;
        int n = this.exitTimes.length;
        int n2 = 0;
        while (n2 < n) {
            double ti = dArray[n2];
            res += Math.log(_a * Math.exp(-_k1 * ti) + (1.0 - _a) * Math.exp(-_k2 * ti));
            ++n2;
        }
        return res;
    }

    private double logPrior2(double _a, double _k1, double _k2) {
        return -Math.log(this.a * _k1 + (1.0 - this.a) * _k2);
    }

    private void step11() {
        double r = Math.random() + 0.5;
        double k_try = r * this.k;
        double pAcc = r * Math.exp(this.logPrior1(k_try) + this.logLikelihood1(k_try) - this.logPrior1(this.k) - this.logLikelihood1(this.k));
        if (Math.random() < pAcc) {
            this.k = k_try;
        }
    }

    private void step22() {
        int sel = MathTools.randomInt(0, 3);
        double a_try = this.a;
        double k1_try = this.k1;
        double k2_try = this.k2;
        double r = 1.0;
        if (sel == 0) {
            a_try = Math.random();
        } else if (sel == 1) {
            r = Math.random() + 0.5;
            k1_try = r * this.k1;
        } else {
            r = Math.random() + 0.5;
            k2_try = r * this.k2;
        }
        double pAcc = r * Math.exp(this.logPrior2(a_try, k1_try, k2_try) + this.logLikelihood2(a_try, k1_try, k2_try) - this.logPrior2(this.a, this.k1, this.k2) - this.logLikelihood2(this.a, this.k1, this.k2));
        if (Math.random() < pAcc) {
            this.a = a_try;
            this.k1 = Math.min(k1_try, k2_try);
            this.k2 = Math.max(k1_try, k2_try);
        }
    }

    private void stepSplit() {
        double a_try = Math.random();
        double b = Math.random();
        double k1_try = b * this.k;
        double k2_try = (1.0 - a_try * b) / (1.0 - a_try) * this.k;
        double logPProp = Math.log((1.0 - b) / ((k2_try - k1_try) * (k2_try - k1_try)));
        double pAcc = Math.exp(-logPProp + this.logPrior2(a_try, k1_try, k2_try) + this.logLikelihood2(a_try, k1_try, k2_try) - this.logPrior1(this.k) - this.logLikelihood1(this.k));
        if (Math.random() < pAcc) {
            this.nExp = 2;
            this.a = a_try;
            this.k1 = k1_try;
            this.k2 = k2_try;
        }
    }

    private void stepMerge() {
        double k_try = this.a * this.k1 + (1.0 - this.a) * this.k2;
        double logPProp = Math.log((1.0 - this.k1 / k_try) / ((this.k2 - this.k1) * (this.k2 - this.k1)));
        double pAcc = Math.exp(logPProp + this.logPrior1(k_try) + this.logLikelihood1(k_try) - this.logPrior2(this.a, this.k1, this.k2) - this.logLikelihood2(this.a, this.k1, this.k2));
        if (Math.random() < pAcc) {
            this.nExp = 1;
            this.k = k_try;
        }
    }

    private void step() {
        if (this.nExp == 1) {
            if (Math.random() < 0.5) {
                this.step11();
            } else {
                this.stepSplit();
            }
        } else if (Math.random() < 0.5) {
            this.step22();
        } else {
            this.stepMerge();
        }
    }

    public void run(int nburnin, int nsample) {
        int i = 0;
        while (i < nburnin) {
            this.step();
            ++i;
        }
        i = 0;
        while (i < nsample) {
            this.step();
            if (this.nExp == 1) {
                ++this.n1;
                this.ksum += this.k;
            } else {
                ++this.n2;
                this.asum += this.a;
                this.k1sum += this.k1;
                this.k2sum += this.k2;
            }
            ++i;
        }
    }

    public double getNumberOfStates() {
        return (double)(this.n1 + 2 * this.n2) / (double)(this.n1 + this.n2);
    }

    public double getMeanK() {
        return this.ksum / (double)this.n1;
    }

    public double[] getMeanK2() {
        return new double[]{this.asum / (double)this.n2, this.k1sum / (double)this.n2, this.k2sum / (double)this.n2};
    }
}

