/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.StringTools;

public class Arguments {
    private String[] commands;
    private String[][] arguments;

    private Arguments(int nCommands) {
        this.commands = new String[nCommands];
        this.arguments = new String[nCommands][];
    }

    public Arguments(String args) {
        this(StringTools.split(args));
    }

    public Arguments(String[] args) {
        int nCommands = 0;
        int i = 0;
        while (i < args.length) {
            if (this.isCommand(args[i])) {
                ++nCommands;
            }
            ++i;
        }
        this.commands = new String[nCommands];
        this.arguments = new String[nCommands][0];
        int k = -1;
        int i2 = 0;
        while (i2 < args.length) {
            if (this.isCommand(args[i2])) {
                this.commands[++k] = args[i2].substring(1, args[i2].length());
            } else {
                if (k == -1) {
                    throw new IllegalArgumentException("Argument list must start with a command, preceded by '-'");
                }
                this.arguments[k] = StringTools.concat(this.arguments[k], args[i2]);
            }
            ++i2;
        }
    }

    private boolean isCommand(String a) {
        if (!a.startsWith("-")) {
            return false;
        }
        return !StringTools.isDouble(a) && !StringTools.isInt(a) && !StringTools.isDoubleArray(a);
    }

    public boolean hasCommand(String cmd) {
        return StringTools.contains(this.commands, cmd);
    }

    public String[] getCommands() {
        return this.commands;
    }

    public String[] getArguments(String cmd) {
        int i = StringTools.findForward(this.commands, cmd);
        if (i < 0) {
            return null;
        }
        return this.arguments[i];
    }

    public boolean hasArgument(String cmd, String arg) {
        if (!this.hasCommand(cmd)) {
            return false;
        }
        return StringTools.contains(this.getArguments(cmd), cmd);
    }

    public int getNArguments(String cmd) {
        return this.getArguments(cmd).length;
    }

    public String getArgument(String cmd, int iArg) {
        return this.getArguments(cmd)[iArg];
    }

    public int getIntArgument(String cmd, int iArg) {
        return StringTools.toInt(this.getArgument(cmd, iArg));
    }

    public int[] getIntArrayArgument(String cmd, int iArg) {
        return StringTools.toIntArray(this.getArgument(cmd, iArg)).getArray();
    }

    public double getDoubleArgument(String cmd, int iArg) {
        return StringTools.toDouble(this.getArgument(cmd, iArg));
    }

    public double[] getDoubleArrayArgument(String cmd, int iArg) {
        return StringTools.toDoubleArray(this.getArgument(cmd, iArg));
    }

    public String getArgument(String cmd) {
        return this.getArguments(cmd)[0];
    }

    public int getIntArgument(String cmd) {
        return this.getIntArgument(cmd, 0);
    }

    public int[] getIntArrayArgument(String cmd) {
        return this.getIntArrayArgument(cmd, 0);
    }

    public double getDoubleArgument(String cmd) {
        return this.getDoubleArgument(cmd, 0);
    }

    public static void main(String[] args) {
        new Arguments(args);
    }
}

