/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Arguments;

class Command {
    Arguments args;
    int nargsFound;
    String command;
    boolean mandatory = false;
    int minNumberOfArgs = 0;
    int maxNumberOfArgs = -1;

    public Command(String cmd, boolean _mandatory) {
        this.command = cmd;
        this.mandatory = _mandatory;
    }

    public void setNumberOfExpectedArgs(int min, int max) {
        this.minNumberOfArgs = min;
        this.maxNumberOfArgs = max;
    }

    public void setArguments(Arguments _args) {
        this.args = _args;
        this.nargsFound = 0;
        if (_args.hasCommand(this.command)) {
            this.nargsFound = _args.getNArguments(this.command);
        }
    }

    public boolean parse() {
        if (this.args.hasCommand(this.command)) {
            if (this.nargsFound < this.minNumberOfArgs) {
                System.out.println("Command -" + this.command + " has " + this.nargsFound + " arguments. Expecting at least " + this.minNumberOfArgs + " arguments.");
                return false;
            }
            if (this.maxNumberOfArgs >= 0 && this.nargsFound > this.maxNumberOfArgs) {
                System.out.println("Command -" + this.command + " has " + this.nargsFound + " arguments. Expecting at most " + this.maxNumberOfArgs + " arguments.");
                return false;
            }
            return true;
        }
        if (this.mandatory) {
            System.out.println("Expected command -" + this.command + " is not present");
            return false;
        }
        return true;
    }
}

