/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Command;
import stallone.util.StringTools;

class DoubleArrayCommand
extends Command {
    double minValue;
    double maxValue;
    double[] value;

    public DoubleArrayCommand(String cmd, boolean _mandatory, double[] _defaultValue, double _minValue, double _maxValue) {
        super(cmd, _mandatory);
        this.value = _defaultValue;
        this.minValue = _minValue;
        this.maxValue = _maxValue;
        if (_defaultValue != null) {
            double[] dArray = _defaultValue;
            int n = _defaultValue.length;
            int n2 = 0;
            while (n2 < n) {
                double dv = dArray[n2];
                if (!(this.minValue <= dv) || !(dv <= this.maxValue)) {
                    throw new IllegalArgumentException("Default value " + _defaultValue + " of double argument " + cmd + " is out of range [" + _minValue + "," + _maxValue + "]");
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean parse() {
        String[] argsFound = this.args.getArguments(this.command);
        this.value = new double[argsFound.length];
        int i = 0;
        while (i < argsFound.length) {
            if (!StringTools.isDouble(argsFound[i])) {
                System.out.println("Command -" + this.command + " has unexpected argument: " + argsFound[i] + ". Expect a double value");
            }
            this.value[i] = StringTools.toDouble(argsFound[i]);
            if (!(this.minValue <= this.value[i]) || !(this.value[i] <= this.maxValue)) {
                System.out.println("Command -" + this.command + " has unexpected argument value: " + this.value + ". Expecting a double in the range [" + this.minValue + "," + this.maxValue + "]");
            }
            ++i;
        }
        return true;
    }

    public double[] getValue() {
        return this.value;
    }
}

