/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import java.util.ArrayList;
import java.util.List;
import stallone.util.Command;
import stallone.util.ExpectedArgument;

class HeterogeneousCommand
extends Command {
    List<ExpectedArgument> arguments = new ArrayList<ExpectedArgument>();

    public HeterogeneousCommand(String cmd, boolean _mandatory) {
        super(cmd, _mandatory);
    }

    public void addArgument(ExpectedArgument arg) {
        if (arg.mandatory) {
            this.addMandatoryArgument();
        } else {
            this.addOptionalArgument();
        }
        this.arguments.add(arg);
    }

    private void addMandatoryArgument() {
        if (this.maxNumberOfArgs > this.minNumberOfArgs) {
            throw new IllegalArgumentException("Trying to add a mandatory argument after an optional argument. This is forbidden.");
        }
        if (this.maxNumberOfArgs == -1) {
            this.minNumberOfArgs = 1;
            this.maxNumberOfArgs = 1;
        } else {
            ++this.minNumberOfArgs;
            ++this.maxNumberOfArgs;
        }
    }

    private void addOptionalArgument() {
        if (this.maxNumberOfArgs == -1) {
            this.minNumberOfArgs = 0;
            this.maxNumberOfArgs = 1;
        } else {
            ++this.maxNumberOfArgs;
        }
    }

    @Override
    public boolean parse() {
        if (!super.parse()) {
            return false;
        }
        if (this.args.hasCommand(this.command)) {
            for (ExpectedArgument ea : this.arguments) {
                if (ea.parse(this.args)) continue;
                return false;
            }
        }
        return true;
    }
}

