/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.util.Command;
import stallone.util.StringTools;

class StringArrayCommand
extends Command {
    String[] options;
    String[] value;

    public StringArrayCommand(String cmd, boolean _mandatory, String[] defaultValue, String[] _options) {
        super(cmd, _mandatory);
        this.value = defaultValue;
        this.options = _options;
    }

    @Override
    public boolean parse() {
        if (!super.parse()) {
            return false;
        }
        this.value = this.args.getArguments(this.command);
        if (this.options != null) {
            int i = 0;
            while (i < this.value.length) {
                if (!StringTools.contains(this.options, this.value[i])) {
                    System.out.println("Command -" + this.command + " has unexpected argument: " + this.value[i] + ". Expected arguments are: { " + StringTools.toString(this.options, ", ") + " }");
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

