/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;

public class StringTools {
    public static String[] List2Array(List<?> al) {
        int size = al.size();
        String[] res = new String[size];
        int k = 0;
        Iterator<?> i = al.iterator();
        while (i.hasNext()) {
            res[k++] = (String)i.next();
        }
        return res;
    }

    public static String readStream(InputStream in) throws IOException {
        StringBuffer strbuf = new StringBuffer();
        int data = 0;
        while (data != -1) {
            data = in.read();
            if (data == -1) continue;
            strbuf.append((char)data);
        }
        in.close();
        return strbuf.toString();
    }

    public static int[] getIntColumn(String str, int col) {
        String[] lines = StringTools.getLines(str);
        int[] integers = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            StringTokenizer tok = new StringTokenizer(lines[i]);
            int j = 0;
            while (j < col) {
                tok.nextToken();
                ++j;
            }
            integers[i] = Integer.valueOf(tok.nextToken());
            ++i;
        }
        return integers;
    }

    public static String[] getStringColumn(String str, int col) {
        String[] lines = StringTools.getLines(str);
        String[] strings = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            StringTokenizer tok = new StringTokenizer(lines[i]);
            int j = 0;
            while (j < col) {
                tok.nextToken();
                ++j;
            }
            strings[i] = tok.nextToken();
            ++i;
        }
        return strings;
    }

    public static String[] getStringMultiColumn(String str, int colFrom) {
        String[] lines = StringTools.getLines(str);
        String[] strings = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            StringTokenizer tok = new StringTokenizer(lines[i]);
            StringBuffer strbuf = new StringBuffer();
            int j = 0;
            while (j < colFrom) {
                tok.nextToken();
                ++j;
            }
            while (tok.hasMoreTokens()) {
                strbuf.append(tok.nextToken());
                if (!tok.hasMoreTokens()) continue;
                strbuf.append(" ");
            }
            strings[i] = strbuf.toString();
            ++i;
        }
        return strings;
    }

    public static String[] getLines(String str) {
        StringTokenizer tok = new StringTokenizer(str, "\n");
        String[] arr = new String[tok.countTokens()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = tok.nextToken();
            ++i;
        }
        return arr;
    }

    public static String[] split(String str) {
        StringTokenizer tok = new StringTokenizer(str);
        String[] arr = new String[tok.countTokens()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = tok.nextToken();
            ++i;
        }
        return arr;
    }

    public static String[][] split(String[] lines) {
        String[][] res = new String[lines.length][];
        int i = 0;
        while (i < res.length) {
            res[i] = StringTools.split(lines[i]);
            ++i;
        }
        return res;
    }

    public static String mergeLines(String[] lines) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            strbuf.append(String.valueOf(lines[i]) + "\n");
            ++i;
        }
        return strbuf.toString();
    }

    public static String[] purgeEmpty(String[] arr) {
        IIntArray drop = Ints.create.array(0);
        int i = 0;
        while (i < arr.length) {
            if (StringTools.split(arr[i]).length == 0) {
                drop = Ints.util.mergeToNew(drop, i);
            }
            ++i;
        }
        IIntArray include = Ints.util.removeValueToNew(Ints.create.arrayRange(arr.length), drop);
        return StringTools.subarray(arr, include);
    }

    public static String replaceAll(String str, String pattern, String value) {
        String res = str;
        int i = res.indexOf(pattern);
        while (i > -1) {
            res = String.valueOf(res.substring(0, i)) + value + res.substring(i + pattern.length(), res.length());
            i = res.indexOf(pattern);
        }
        return res;
    }

    public static boolean isInt(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int leadingInt(String str) {
        int k = 0;
        while (k < str.length()) {
            if (!Character.isDigit(str.charAt(k))) break;
            ++k;
        }
        if (k == 0) {
            return -1;
        }
        return StringTools.toInt(str.substring(0, k));
    }

    public static boolean startsWithInt(String str) {
        String[] words = StringTools.split(str);
        if (words.length == 0) {
            return false;
        }
        return StringTools.isInt(words[0]);
    }

    public static int nextInt(String str, int s) {
        int k = s;
        while (k < str.length() && !Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i1 = k;
        while (k < str.length() && Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i2 = k;
        if (i2 - i1 < 1) {
            return -1;
        }
        return StringTools.toInt(str.substring(i1, i2));
    }

    public static long nextLong(String str, int s) {
        int k = s;
        while (k < str.length() && !Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i1 = k;
        while (k < str.length() && Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i2 = k;
        if (i2 - i1 < 1) {
            return -1L;
        }
        return StringTools.toLong(str.substring(i1, i2));
    }

    public static int toInt(String str) {
        return Integer.valueOf(str);
    }

    public static long toLong(String str) {
        return Long.valueOf(str);
    }

    public static String[][] transpose(String[][] arr) {
        int nCol = arr.length;
        int nLin = arr[0].length;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].length != nLin) {
                System.out.println(arr[i].length);
                throw new IllegalArgumentException("Trying to transpose a non-matrix-array");
            }
            ++i;
        }
        String[][] res = new String[nLin][nCol];
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = arr[j][i2];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static IIntArray toIntArray(String[] str) {
        IIntArray res = Ints.create.array(str.length);
        int i = 0;
        while (i < str.length) {
            res.set(i, StringTools.toInt(str[i]));
            ++i;
        }
        return res;
    }

    public static IIntArray toIntMatrix(String[][] str) {
        IIntArray res = Ints.create.table(str.length, str[0].length);
        int r = 0;
        int i = 0;
        while (i < str.length) {
            if (str[i].length > 0) {
                ++r;
            }
            int j = 0;
            while (j < str[i].length) {
                res.set(i, j, StringTools.toInt(str[i][j]));
                ++j;
            }
            ++i;
        }
        return Ints.util.subRowsToNew(res, Ints.create.arrayRange(r));
    }

    public static IIntArray toIntArray(String str) {
        String[] strarr = StringTools.split(str);
        if (StringTools.isInt(strarr[0])) {
            return StringTools.toIntArray(strarr);
        }
        strarr = str.split(",");
        if (StringTools.isInt(strarr[0])) {
            return StringTools.toIntArray(strarr);
        }
        strarr = str.split(";");
        if (StringTools.isInt(strarr[0])) {
            return StringTools.toIntArray(strarr);
        }
        throw new IllegalArgumentException("No int array: " + str);
    }

    public static boolean isIntArray(String str) {
        try {
            StringTools.toIntArray(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double toDouble(String str) {
        String enString = str;
        int i = str.indexOf(",");
        if (i != -1) {
            StringBuffer strbuf = new StringBuffer(str);
            strbuf.setCharAt(i, '.');
            enString = strbuf.toString();
        }
        return Double.valueOf(str);
    }

    public static double[] toDoubleArray(String[] str) {
        double[] res = new double[str.length];
        int i = 0;
        while (i < str.length) {
            res[i] = StringTools.toDouble(str[i]);
            ++i;
        }
        return res;
    }

    public static double[][] toDoubleArray(String[][] str) {
        double[][] res = new double[str.length][];
        int i = 0;
        while (i < str.length) {
            res[i] = StringTools.toDoubleArray(str[i]);
            ++i;
        }
        return res;
    }

    public static boolean isDoubleArray(String str) {
        try {
            StringTools.toDoubleArray(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static double[] toDoubleArray(String str) {
        String[] strarr = StringTools.split(str);
        if (StringTools.isDouble(strarr[0])) {
            return StringTools.toDoubleArray(strarr);
        }
        strarr = str.split(",");
        if (StringTools.isDouble(strarr[0])) {
            return StringTools.toDoubleArray(strarr);
        }
        strarr = str.split(";");
        if (StringTools.isDouble(strarr[0])) {
            return StringTools.toDoubleArray(strarr);
        }
        throw new IllegalArgumentException("No double array: " + str);
    }

    public static String flushLeft(String str, int size) {
        StringBuffer strbuf = new StringBuffer(str);
        int i = str.length();
        while (i < size) {
            strbuf.append(" ");
            ++i;
        }
        return strbuf.toString();
    }

    public static String flushRight(String str, int size) {
        StringBuffer strbuf = new StringBuffer();
        int i = str.length();
        while (i < size) {
            strbuf.append(" ");
            ++i;
        }
        strbuf.append(str);
        return strbuf.toString();
    }

    public static String[] toStringArray(LinkedList<?> list) {
        String[] res = new String[list.size()];
        int k = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            res[k++] = (String)i.next();
        }
        return res;
    }

    public static String[] sortByFirstNumber(String[] arr) {
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr.length - 1) {
                long i1 = StringTools.nextLong(arr[j], 0);
                if (i1 < 0L) {
                    i1 = Integer.MAX_VALUE;
                }
                long i2 = StringTools.nextLong(arr[j + 1], 0);
                if (i1 < 0L) {
                    i2 = Integer.MAX_VALUE;
                }
                if (i1 > i2) {
                    String h = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = h;
                }
                ++j;
            }
            ++i;
        }
        return arr;
    }

    public static String[] concat(String[] a1, String[] a2) {
        String[] res = new String[a1.length + a2.length];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static String[][] concat(String[][] a1, String[][] a2) {
        String[][] res = new String[a1.length + a2.length][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static String[] concat(String[] a1, String a2) {
        String[] res = new String[a1.length + 1];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static String[][] concat(String[][] a1, String[] a2) {
        String[][] res = new String[a1.length + 1][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static boolean contains(String[] arr, String pattern) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int findForward(String[] arr, String pattern, int iStart) {
        int i = iStart;
        while (i < arr.length) {
            if (arr[i].equals(pattern)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findForward(String[] arr, String pattern) {
        return StringTools.findForward(arr, pattern, 0);
    }

    public static int findBackward(String[] arr, String pattern, int iStart) {
        int i = iStart;
        while (i >= 0) {
            if (arr[i].equals(pattern)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBackward(String[] arr, String pattern) {
        return StringTools.findForward(arr, pattern, arr.length - 1);
    }

    public static String[] copy(String[] arr) {
        String[] res = new String[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    public static String[] subarray(String[] arr, int i1, int i2) {
        String[] res = new String[i2 - i1];
        int i = i1;
        while (i < i2) {
            res[i - i1] = arr[i];
            ++i;
        }
        return res;
    }

    public static String[] subarray(String[] arr, int[] indexes) {
        String[] res = new String[indexes.length];
        int i = 0;
        int k = 0;
        while (i < indexes.length) {
            res[k++] = arr[indexes[i]];
            ++i;
        }
        return res;
    }

    public static String[] subarray(String[] arr, IIntArray indexes) {
        return StringTools.subarray(arr, indexes.getArray());
    }

    public static String[][] subarray(String[][] arr, int i1, int i2) {
        String[][] res = new String[i2 - i1][];
        int i = i1;
        while (i < i2) {
            res[i - i1] = arr[i];
            ++i;
        }
        return res;
    }

    public static String[][] subarray(String[][] arr, IIntArray indexes) {
        String[][] res = new String[indexes.size()][];
        int i = 0;
        int k = 0;
        while (i < indexes.size()) {
            res[k++] = arr[indexes.get(i)];
            ++i;
        }
        return res;
    }

    public static String[] drop(String[] arr, IIntArray droplist) {
        IIntArray include = Ints.util.removeValueToNew(Ints.create.arrayRange(arr.length), droplist);
        return StringTools.subarray(arr, include);
    }

    public static String[] dropLeading(String[] arr, String pattern) {
        IIntArray droplist = Ints.create.array(0);
        int i = 0;
        while (i < arr.length) {
            if (arr[i].startsWith(pattern)) {
                droplist = Ints.util.mergeToNew(droplist, i);
            }
            ++i;
        }
        return StringTools.drop(arr, droplist);
    }

    public static String[] getColumn(String[][] arr, int k) {
        String[] res = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i][k];
            ++i;
        }
        return res;
    }

    public static String[] flatten(String[][] arr) {
        int n = 0;
        int i = 0;
        while (i < arr.length) {
            n += arr[i].length;
            ++i;
        }
        String[] res = new String[n];
        int i2 = 0;
        int k = 0;
        while (i2 < arr.length) {
            int j = 0;
            while (j < arr[i2].length) {
                res[k++] = arr[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static String[][] flatten(String[][][] arr) {
        int n = 0;
        int i = 0;
        while (i < arr.length) {
            n += arr[i].length;
            ++i;
        }
        String[][] res = new String[n][];
        int i2 = 0;
        int k = 0;
        while (i2 < arr.length) {
            int j = 0;
            while (j < arr[i2].length) {
                res[k++] = arr[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static String toString(String[] arr, String del) {
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuffer strbuf = new StringBuffer(arr[0]);
        int i = 1;
        while (i < arr.length) {
            strbuf.append(String.valueOf(del) + arr[i]);
            ++i;
        }
        return strbuf.toString();
    }

    public static String toString(String[] arr) {
        return StringTools.toString(arr, ",");
    }

    public static void print(String[] str) {
        System.out.print(StringTools.toString(str));
    }

    public static void print(String[] str, String del) {
        System.out.print(StringTools.toString(str, del));
    }

    public static void print(String[][] str, String coldel, String linedel) {
        int i = 0;
        while (i < str.length) {
            StringTools.print(str[i], coldel);
            System.out.print(linedel);
            ++i;
        }
    }

    public static void print(String[][] str) {
        StringTools.print(str, ",", "\n");
    }

    public static String toScientific(double I, int digits) {
        StringBuffer strbuf = new StringBuffer("0.");
        int i = 0;
        while (i < digits) {
            strbuf.append("#");
            ++i;
        }
        strbuf.append("E0");
        DecimalFormat df = new DecimalFormat(strbuf.toString());
        return df.format(I);
    }

    public static String toPrecision(double I, int digits1, int digits2) {
        if (digits2 == 0) {
            return String.valueOf((int)Math.round(I));
        }
        StringBuffer strbuf = new StringBuffer("");
        int i = 0;
        while (i < digits1 - 1) {
            strbuf.append("#");
            ++i;
        }
        strbuf.append("0.");
        i = 0;
        while (i < digits2) {
            strbuf.append("#");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(strbuf.toString(), new DecimalFormatSymbols(Locale.ENGLISH));
        return df.format(I);
    }
}

