import unittest

from pystan import stanc


def test_stanc():
    model_code = 'parameters {real y;} model {y ~ normal(0,1);}'
    result = stanc(model_code=model_code)
    assert sorted(result.keys()) == sorted({"status", "model_cppname",
                                            "cppcode", "model_name",
                                            "model_code"})
    assert result['cppcode'].startswith("// Code generated by Stan ")
    assert result['status'] == 0

def test_stanc_exception():
    model_code = 'parameters {real z;} model {y ~ no_such_distribution();}'
    result = stanc(model_code=model_code)
    assert result['status'] == -1
