#!/usr/bin/env python
# -*- coding: utf8 -*-

import os.path, sys
from distutils.core import setup, Extension

VERSION = '1.75.00-2'

if 'build' in sys.argv or 'install' in sys.argv:
	instdir = os.path.dirname(os.path.abspath(__file__))
	os.chdir(os.path.join(instdir, 'src'))
	os.system('make clean')
	os.system('make libswe.a')
	os.chdir(instdir)

swemodule = Extension(
	'swisseph',
	include_dirs = ['src'],
	libraries = ['swe'],
	library_dirs = ['src'],
	sources = ['pyswisseph.c', 'swhdatetime.c', 'swhfmt.c', 'swhsearch.c']
)

setup(
	name = 'pyswisseph',
	version = VERSION,
	description='Python extension to the Swiss Ephemeris',
	long_description="""Python extension to AstroDienst's Swiss Ephemeris library.

Swiss Ephemeris homepage: http://www.astro.com/swisseph

Now Python 3 compatible.

Usage example:

>>> import swisseph as swe
>>> swe.set_ephe_path('/usr/share/ephe') # set path to ephemeris files
>>> now = swe.julday(2007,3,3) # get Julian day number
>>> res = swe.lun_eclipse_when(now) # find next lunar eclipse (from now on)
>>> ecltime = swe.revjul(res[1][0]) # get date UTC
>>> ecltime
(2007, 3, 3, 23.347975596785545)
>>> jd = swe.julday(2008,3,21)
>>> swe.calc_ut(jd, swe.AST_OFFSET+13681)[0] # asteroid Monty Python
0.098474291148756998
>>> help(swe)

Installation: ``# python setup.py install``
""",
	author='S.Marquis',
	author_email='stnsls@gmail.com',
	url='http://pyswisseph.atarax.org',
	download_url='http://pypi.python.org/pypi/pyswisseph',
	classifiers=[
		'Development Status :: 5 - Production/Stable',
		'Intended Audience :: Developers',
		'Intended Audience :: Religion',
		'License :: OSI Approved :: GNU General Public License (GPL)',
		'Programming Language :: C',
		'Programming Language :: Python',
		'Topic :: Religion',
		'Topic :: Scientific/Engineering :: Astronomy',
		'Topic :: Software Development :: Libraries :: Python Modules'
		],
	keywords='Astrology Ephemeris Swisseph',
	ext_modules = [swemodule]
)

# End.
