/*
    Swephelp

    Copyright 2007-2009 Stanislas Marquis <stnsls@gmail.com>

    Swephelp is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    Swephelp is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Swephelp.  If not, see <http://www.gnu.org/licenses/>.
*/

/** @file swephelp.h
** @brief swephelp export header file.
**
** Main swephelp header, imports all swephelp functions and defines.
**
** @author Stanislas Marquis <stnsls@gmail.com>
** @date 11.01.2009
** @remarks Based on swisseph version 1.75.00
*/

#ifndef SWEPHELP_H
#define SWEPHELP_H

#ifndef SWH_USE_ALIASES
#define SWH_USE_ALIASES     1
#endif

#ifndef SWH_USE_THREADS
#define SWH_USE_THREADS     1
#endif

#include <swephexp.h>

#include "swhdef.h"
#include "swhdatetime.h"
#include "swhformat.h"
#include "swhsearch.h"
#include "swhraman.h"
#include "swhgeo.h"
#include "swhutil.h"

#endif /* swephelp.h */
