/* File: teos_airmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * See http://cens.ioc.ee/projects/f2py2e/
 * Generation date: Fri Nov  9 12:19:02 2012
 * $Revision:$
 * $Date:$
 * Do not edit this file directly unless you know what you are doing!!!
 */
#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <string.h>
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *teos_air_error;
static PyObject *teos_air_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef char * string;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
\
#define FAILNULL(p) do {                                            \
    if ((p) == NULL) {                                              \
        PyErr_SetString(PyExc_MemoryError, "NULL pointer found");   \
        goto capi_fail;                                             \
    }                                                               \
} while (0)

#define STRINGMALLOC(str,len)\
  if ((str = (string)malloc(sizeof(char)*(len+1))) == NULL) {\
    PyErr_SetString(PyExc_MemoryError, "out of memory");\
    goto capi_fail;\
  } else {\
    (str)[len] = '\0';\
  }

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (((PyArrayObject *)(capi_ ## var ## _tmp))->nd)
#define old_shape(var,dim) (((PyArrayObject *)(capi_ ## var ## _tmp))->dimensions[dim])
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define STRINGFREE(str) do {if (!(str == NULL)) free(str);} while (0)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define CHECKSCALAR(check,tcheck,name,show,var)\
  if (!(check)) {\
    char errstring[256];\
    sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
    PyErr_SetString(teos_air_error,errstring);\
    /*goto capi_fail;*/\
  } else 
#define STRINGCOPYN(to,from,buf_size)                           \
    do {                                                        \
        int _m = (buf_size);                                    \
        char *_to = (to);                                       \
        char *_from = (from);                                   \
        FAILNULL(_to); FAILNULL(_from);                         \
        (void)strncpy(_to, _from, sizeof(char)*_m);             \
        _to[_m-1] = '\0';                                      \
        /* Padding with spaces instead of nulls */              \
        for (_m -= 2; _m >= 0 && _to[_m] == '\0'; _m--) {      \
            _to[_m] = ' ';                                      \
        }                                                       \
    } while (0)


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int string_from_pyobj(string *str,int *len,const string inistr,PyObject *obj,const char *errmess) {
  PyArrayObject *arr = NULL;
  PyObject *tmp = NULL;
#ifdef DEBUGCFUNCS
fprintf(stderr,"string_from_pyobj(str='%s',len=%d,inistr='%s',obj=%p)\n",(char*)str,*len,(char *)inistr,obj);
#endif
  if (obj == Py_None) {
    if (*len == -1)
      *len = strlen(inistr); /* Will this cause problems? */
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,inistr,*len+1);
    return 1;
  }
  if (PyArray_Check(obj)) {
    if ((arr = (PyArrayObject *)obj) == NULL)
      goto capi_fail;
    if (!ISCONTIGUOUS(arr)) {
      PyErr_SetString(PyExc_ValueError,"array object is non-contiguous.");
      goto capi_fail;
    }
    if (*len == -1)
      *len = (arr->descr->elsize)*PyArray_SIZE(arr);
    STRINGMALLOC(*str,*len);
    STRINGCOPYN(*str,arr->data,*len+1);
    return 1;
  }
  if (PyString_Check(obj)) {
    tmp = obj;
    Py_INCREF(tmp);
  }
#if PY_VERSION_HEX >= 0x03000000
  else if (PyUnicode_Check(obj)) {
    tmp = PyUnicode_AsASCIIString(obj);
  }
  else {
    PyObject *tmp2;
    tmp2 = PyObject_Str(obj);
    if (tmp2) {
      tmp = PyUnicode_AsASCIIString(tmp2);
      Py_DECREF(tmp2);
    }
    else {
      tmp = NULL;
    }
  }
#else
  else {
    tmp = PyObject_Str(obj);
  }
#endif
  if (tmp == NULL) goto capi_fail;
  if (*len == -1)
    *len = PyString_GET_SIZE(tmp);
  STRINGMALLOC(*str,*len);
  STRINGCOPYN(*str,PyString_AS_STRING(tmp),*len+1);
  Py_DECREF(tmp);
  return 1;
capi_fail:
  Py_XDECREF(tmp);
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = teos_air_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyInt_Check(obj)) {
    *v = (int)PyInt_AS_LONG(obj);
    return 1;
  }
  tmp = PyNumber_Int(obj);
  if (tmp) {
    *v = PyInt_AS_LONG(tmp);
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = teos_air_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC_US(liq_ice_air_sat_desc,LIQ_ICE_AIR_SAT_DESC)(string,string,size_t,size_t);
extern void F_FUNC_US(liq_ice_air_sat,LIQ_ICE_AIR_SAT)(string,double*,double*,int*,int*,int*,double*,size_t);
extern void F_FUNC_US(liq_ice_air_g_ref_desc,LIQ_ICE_AIR_G_REF_DESC)(string,string,size_t,size_t);
extern void F_FUNC_US(liq_ice_air_g_ref,LIQ_ICE_AIR_G_REF)(string,double*,double*,double*,double*,int*,int*,int*,double*,size_t);
extern void F_FUNC_US(liq_ice_air_g_desc,LIQ_ICE_AIR_G_DESC)(string,string,size_t,size_t);
extern void F_FUNC_US(liq_ice_air_g,LIQ_ICE_AIR_G)(string,double*,double*,double*,int*,int*,int*,double*,size_t);
extern void F_FUNC_US(liq_ice_air_h_desc,LIQ_ICE_AIR_H_DESC)(string,string,size_t,size_t);
extern void F_FUNC_US(liq_ice_air_h,LIQ_ICE_AIR_H)(string,double*,double*,double*,int*,int*,int*,double*,size_t);
extern void F_FUNC_US(liq_ice_air_il_desc,LIQ_ICE_AIR_IL_DESC)(string,string,size_t,size_t);
extern void F_FUNC_US(liq_ice_air_il,LIQ_ICE_AIR_IL)(string,double*,double*,int*,int*,int*,double*,size_t);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/**************************** liq_ice_air_sat_desc ****************************/
static char doc_f2py_rout_teos_air_liq_ice_air_sat_desc[] = "\
Function signature:\n\
  description = liq_ice_air_sat_desc(in_name)\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"Return objects:\n"
"  description : string(len=1000)";
/* extern void F_FUNC_US(liq_ice_air_sat_desc,LIQ_ICE_AIR_SAT_DESC)(string,string,size_t,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_sat_desc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  string description = NULL;
  int slen(description);
  PyObject *description_capi = Py_None;
  static char *capi_kwlist[] = {"in_name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:teos_air.liq_ice_air_sat_desc",\
    capi_kwlist,&in_name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable description */
  slen(description) = 1000;
  f2py_success = string_from_pyobj(&description,&slen(description),"",description_capi,"string_from_pyobj failed in converting hidden `description' of teos_air.liq_ice_air_sat_desc to C string");
  if (f2py_success) {
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_sat_desc to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,description,slen(in_name),slen(description));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("z",description);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
    STRINGFREE(description);
  }  /*if (f2py_success) of description*/
  /* End of cleaning variable description */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************ end of liq_ice_air_sat_desc ************************/

/****************************** liq_ice_air_sat ******************************/
static char doc_f2py_rout_teos_air_liq_ice_air_sat[] = "\
Function signature:\n\
  out_val = liq_ice_air_sat(in_name,in_t,in_p,[k,l,m])\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"  in_t : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_p : input rank-3 array('d') with bounds (k,l,m)\n"
"Optional arguments:\n"
"  k := shape(in_t,0) input int\n"
"  l := shape(in_t,1) input int\n"
"  m := shape(in_t,2) input int\n"
"Return objects:\n"
"  out_val : rank-3 array('d') with bounds (k,l,m)";
/* extern void F_FUNC_US(liq_ice_air_sat,LIQ_ICE_AIR_SAT)(string,double*,double*,int*,int*,int*,double*,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_sat(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,int*,int*,int*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  double *in_t = NULL;
  npy_intp in_t_Dims[3] = {-1, -1, -1};
  const int in_t_Rank = 3;
  PyArrayObject *capi_in_t_tmp = NULL;
  int capi_in_t_intent = 0;
  PyObject *in_t_capi = Py_None;
  double *in_p = NULL;
  npy_intp in_p_Dims[3] = {-1, -1, -1};
  const int in_p_Rank = 3;
  PyArrayObject *capi_in_p_tmp = NULL;
  int capi_in_p_intent = 0;
  PyObject *in_p_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *out_val = NULL;
  npy_intp out_val_Dims[3] = {-1, -1, -1};
  const int out_val_Rank = 3;
  PyArrayObject *capi_out_val_tmp = NULL;
  int capi_out_val_intent = 0;
  static char *capi_kwlist[] = {"in_name","in_t","in_p","k","l","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|OOO:teos_air.liq_ice_air_sat",\
    capi_kwlist,&in_name_capi,&in_t_capi,&in_p_capi,&k_capi,&l_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable in_t */
  ;
  capi_in_t_intent |= F2PY_INTENT_IN;
  capi_in_t_tmp = array_from_pyobj(PyArray_DOUBLE,in_t_Dims,in_t_Rank,capi_in_t_intent,in_t_capi);
  if (capi_in_t_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 2nd argument `in_t' of teos_air.liq_ice_air_sat to C/Fortran array" );
  } else {
    in_t = (double *)(capi_in_t_tmp->data);

  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_sat to C string");
  if (f2py_success) {
  /* Processing variable k */
  if (k_capi == Py_None) k = shape(in_t,0); else
    f2py_success = int_from_pyobj(&k,k_capi,"teos_air.liq_ice_air_sat() 1st keyword (k) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_t,0)==k,"shape(in_t,0)==k","1st keyword k","liq_ice_air_sat:k=%d",k) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(in_t,2); else
    f2py_success = int_from_pyobj(&m,m_capi,"teos_air.liq_ice_air_sat() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_t,2)==m,"shape(in_t,2)==m","3rd keyword m","liq_ice_air_sat:m=%d",m) {
  /* Processing variable l */
  if (l_capi == Py_None) l = shape(in_t,1); else
    f2py_success = int_from_pyobj(&l,l_capi,"teos_air.liq_ice_air_sat() 2nd keyword (l) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_t,1)==l,"shape(in_t,1)==l","2nd keyword l","liq_ice_air_sat:l=%d",l) {
  /* Processing variable in_p */
  in_p_Dims[0]=k,in_p_Dims[1]=l,in_p_Dims[2]=m;
  capi_in_p_intent |= F2PY_INTENT_IN;
  capi_in_p_tmp = array_from_pyobj(PyArray_DOUBLE,in_p_Dims,in_p_Rank,capi_in_p_intent,in_p_capi);
  if (capi_in_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 3rd argument `in_p' of teos_air.liq_ice_air_sat to C/Fortran array" );
  } else {
    in_p = (double *)(capi_in_p_tmp->data);

  /* Processing variable out_val */
  out_val_Dims[0]=k,out_val_Dims[1]=l,out_val_Dims[2]=m;
  capi_out_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_out_val_tmp = array_from_pyobj(PyArray_DOUBLE,out_val_Dims,out_val_Rank,capi_out_val_intent,Py_None);
  if (capi_out_val_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting hidden `out_val' of teos_air.liq_ice_air_sat to C/Fortran array" );
  } else {
    out_val = (double *)(capi_out_val_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,in_t,in_p,&k,&l,&m,out_val,slen(in_name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_out_val_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_out_val_tmp == NULL) ... else of out_val*/
  /* End of cleaning variable out_val */
  if((PyObject *)capi_in_p_tmp!=in_p_capi) {
    Py_XDECREF(capi_in_p_tmp); }
  }  /*if (capi_in_p_tmp == NULL) ... else of in_p*/
  /* End of cleaning variable in_p */
  } /*CHECKSCALAR(shape(in_t,1)==l)*/
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*CHECKSCALAR(shape(in_t,2)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(in_t,0)==k)*/
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
  if((PyObject *)capi_in_t_tmp!=in_t_capi) {
    Py_XDECREF(capi_in_t_tmp); }
  }  /*if (capi_in_t_tmp == NULL) ... else of in_t*/
  /* End of cleaning variable in_t */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of liq_ice_air_sat ***************************/

/*************************** liq_ice_air_g_ref_desc ***************************/
static char doc_f2py_rout_teos_air_liq_ice_air_g_ref_desc[] = "\
Function signature:\n\
  description = liq_ice_air_g_ref_desc(in_name)\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"Return objects:\n"
"  description : string(len=1000)";
/* extern void F_FUNC_US(liq_ice_air_g_ref_desc,LIQ_ICE_AIR_G_REF_DESC)(string,string,size_t,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_g_ref_desc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  string description = NULL;
  int slen(description);
  PyObject *description_capi = Py_None;
  static char *capi_kwlist[] = {"in_name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:teos_air.liq_ice_air_g_ref_desc",\
    capi_kwlist,&in_name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable description */
  slen(description) = 1000;
  f2py_success = string_from_pyobj(&description,&slen(description),"",description_capi,"string_from_pyobj failed in converting hidden `description' of teos_air.liq_ice_air_g_ref_desc to C string");
  if (f2py_success) {
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_g_ref_desc to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,description,slen(in_name),slen(description));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("z",description);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
    STRINGFREE(description);
  }  /*if (f2py_success) of description*/
  /* End of cleaning variable description */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of liq_ice_air_g_ref_desc ***********************/

/***************************** liq_ice_air_g_ref *****************************/
static char doc_f2py_rout_teos_air_liq_ice_air_g_ref[] = "\
Function signature:\n\
  out_val = liq_ice_air_g_ref(in_name,in_q,in_t,in_p,in_ref,[k,l,m])\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"  in_q : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_t : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_p : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_ref : input rank-3 array('d') with bounds (k,l,m)\n"
"Optional arguments:\n"
"  k := shape(in_q,0) input int\n"
"  l := shape(in_q,1) input int\n"
"  m := shape(in_q,2) input int\n"
"Return objects:\n"
"  out_val : rank-3 array('d') with bounds (k,l,m)";
/* extern void F_FUNC_US(liq_ice_air_g_ref,LIQ_ICE_AIR_G_REF)(string,double*,double*,double*,double*,int*,int*,int*,double*,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_g_ref(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,double*,double*,int*,int*,int*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  double *in_q = NULL;
  npy_intp in_q_Dims[3] = {-1, -1, -1};
  const int in_q_Rank = 3;
  PyArrayObject *capi_in_q_tmp = NULL;
  int capi_in_q_intent = 0;
  PyObject *in_q_capi = Py_None;
  double *in_t = NULL;
  npy_intp in_t_Dims[3] = {-1, -1, -1};
  const int in_t_Rank = 3;
  PyArrayObject *capi_in_t_tmp = NULL;
  int capi_in_t_intent = 0;
  PyObject *in_t_capi = Py_None;
  double *in_p = NULL;
  npy_intp in_p_Dims[3] = {-1, -1, -1};
  const int in_p_Rank = 3;
  PyArrayObject *capi_in_p_tmp = NULL;
  int capi_in_p_intent = 0;
  PyObject *in_p_capi = Py_None;
  double *in_ref = NULL;
  npy_intp in_ref_Dims[3] = {-1, -1, -1};
  const int in_ref_Rank = 3;
  PyArrayObject *capi_in_ref_tmp = NULL;
  int capi_in_ref_intent = 0;
  PyObject *in_ref_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *out_val = NULL;
  npy_intp out_val_Dims[3] = {-1, -1, -1};
  const int out_val_Rank = 3;
  PyArrayObject *capi_out_val_tmp = NULL;
  int capi_out_val_intent = 0;
  static char *capi_kwlist[] = {"in_name","in_q","in_t","in_p","in_ref","k","l","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOO|OOO:teos_air.liq_ice_air_g_ref",\
    capi_kwlist,&in_name_capi,&in_q_capi,&in_t_capi,&in_p_capi,&in_ref_capi,&k_capi,&l_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_g_ref to C string");
  if (f2py_success) {
  /* Processing variable in_q */
  ;
  capi_in_q_intent |= F2PY_INTENT_IN;
  capi_in_q_tmp = array_from_pyobj(PyArray_DOUBLE,in_q_Dims,in_q_Rank,capi_in_q_intent,in_q_capi);
  if (capi_in_q_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 2nd argument `in_q' of teos_air.liq_ice_air_g_ref to C/Fortran array" );
  } else {
    in_q = (double *)(capi_in_q_tmp->data);

  /* Processing variable k */
  if (k_capi == Py_None) k = shape(in_q,0); else
    f2py_success = int_from_pyobj(&k,k_capi,"teos_air.liq_ice_air_g_ref() 1st keyword (k) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,0)==k,"shape(in_q,0)==k","1st keyword k","liq_ice_air_g_ref:k=%d",k) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(in_q,2); else
    f2py_success = int_from_pyobj(&m,m_capi,"teos_air.liq_ice_air_g_ref() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,2)==m,"shape(in_q,2)==m","3rd keyword m","liq_ice_air_g_ref:m=%d",m) {
  /* Processing variable l */
  if (l_capi == Py_None) l = shape(in_q,1); else
    f2py_success = int_from_pyobj(&l,l_capi,"teos_air.liq_ice_air_g_ref() 2nd keyword (l) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,1)==l,"shape(in_q,1)==l","2nd keyword l","liq_ice_air_g_ref:l=%d",l) {
  /* Processing variable in_t */
  in_t_Dims[0]=k,in_t_Dims[1]=l,in_t_Dims[2]=m;
  capi_in_t_intent |= F2PY_INTENT_IN;
  capi_in_t_tmp = array_from_pyobj(PyArray_DOUBLE,in_t_Dims,in_t_Rank,capi_in_t_intent,in_t_capi);
  if (capi_in_t_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 3rd argument `in_t' of teos_air.liq_ice_air_g_ref to C/Fortran array" );
  } else {
    in_t = (double *)(capi_in_t_tmp->data);

  /* Processing variable in_p */
  in_p_Dims[0]=k,in_p_Dims[1]=l,in_p_Dims[2]=m;
  capi_in_p_intent |= F2PY_INTENT_IN;
  capi_in_p_tmp = array_from_pyobj(PyArray_DOUBLE,in_p_Dims,in_p_Rank,capi_in_p_intent,in_p_capi);
  if (capi_in_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 4th argument `in_p' of teos_air.liq_ice_air_g_ref to C/Fortran array" );
  } else {
    in_p = (double *)(capi_in_p_tmp->data);

  /* Processing variable in_ref */
  in_ref_Dims[0]=k,in_ref_Dims[1]=l,in_ref_Dims[2]=m;
  capi_in_ref_intent |= F2PY_INTENT_IN;
  capi_in_ref_tmp = array_from_pyobj(PyArray_DOUBLE,in_ref_Dims,in_ref_Rank,capi_in_ref_intent,in_ref_capi);
  if (capi_in_ref_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 5th argument `in_ref' of teos_air.liq_ice_air_g_ref to C/Fortran array" );
  } else {
    in_ref = (double *)(capi_in_ref_tmp->data);

  /* Processing variable out_val */
  out_val_Dims[0]=k,out_val_Dims[1]=l,out_val_Dims[2]=m;
  capi_out_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_out_val_tmp = array_from_pyobj(PyArray_DOUBLE,out_val_Dims,out_val_Rank,capi_out_val_intent,Py_None);
  if (capi_out_val_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting hidden `out_val' of teos_air.liq_ice_air_g_ref to C/Fortran array" );
  } else {
    out_val = (double *)(capi_out_val_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,in_q,in_t,in_p,in_ref,&k,&l,&m,out_val,slen(in_name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_out_val_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_out_val_tmp == NULL) ... else of out_val*/
  /* End of cleaning variable out_val */
  if((PyObject *)capi_in_ref_tmp!=in_ref_capi) {
    Py_XDECREF(capi_in_ref_tmp); }
  }  /*if (capi_in_ref_tmp == NULL) ... else of in_ref*/
  /* End of cleaning variable in_ref */
  if((PyObject *)capi_in_p_tmp!=in_p_capi) {
    Py_XDECREF(capi_in_p_tmp); }
  }  /*if (capi_in_p_tmp == NULL) ... else of in_p*/
  /* End of cleaning variable in_p */
  if((PyObject *)capi_in_t_tmp!=in_t_capi) {
    Py_XDECREF(capi_in_t_tmp); }
  }  /*if (capi_in_t_tmp == NULL) ... else of in_t*/
  /* End of cleaning variable in_t */
  } /*CHECKSCALAR(shape(in_q,1)==l)*/
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*CHECKSCALAR(shape(in_q,2)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(in_q,0)==k)*/
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_in_q_tmp!=in_q_capi) {
    Py_XDECREF(capi_in_q_tmp); }
  }  /*if (capi_in_q_tmp == NULL) ... else of in_q*/
  /* End of cleaning variable in_q */
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of liq_ice_air_g_ref **************************/

/***************************** liq_ice_air_g_desc *****************************/
static char doc_f2py_rout_teos_air_liq_ice_air_g_desc[] = "\
Function signature:\n\
  description = liq_ice_air_g_desc(in_name)\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"Return objects:\n"
"  description : string(len=1000)";
/* extern void F_FUNC_US(liq_ice_air_g_desc,LIQ_ICE_AIR_G_DESC)(string,string,size_t,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_g_desc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  string description = NULL;
  int slen(description);
  PyObject *description_capi = Py_None;
  static char *capi_kwlist[] = {"in_name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:teos_air.liq_ice_air_g_desc",\
    capi_kwlist,&in_name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable description */
  slen(description) = 1000;
  f2py_success = string_from_pyobj(&description,&slen(description),"",description_capi,"string_from_pyobj failed in converting hidden `description' of teos_air.liq_ice_air_g_desc to C string");
  if (f2py_success) {
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_g_desc to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,description,slen(in_name),slen(description));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("z",description);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
    STRINGFREE(description);
  }  /*if (f2py_success) of description*/
  /* End of cleaning variable description */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of liq_ice_air_g_desc *************************/

/******************************* liq_ice_air_g *******************************/
static char doc_f2py_rout_teos_air_liq_ice_air_g[] = "\
Function signature:\n\
  out_val = liq_ice_air_g(in_name,in_q,in_t,in_p,[k,l,m])\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"  in_q : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_t : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_p : input rank-3 array('d') with bounds (k,l,m)\n"
"Optional arguments:\n"
"  k := shape(in_q,0) input int\n"
"  l := shape(in_q,1) input int\n"
"  m := shape(in_q,2) input int\n"
"Return objects:\n"
"  out_val : rank-3 array('d') with bounds (k,l,m)";
/* extern void F_FUNC_US(liq_ice_air_g,LIQ_ICE_AIR_G)(string,double*,double*,double*,int*,int*,int*,double*,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_g(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,double*,int*,int*,int*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  double *in_q = NULL;
  npy_intp in_q_Dims[3] = {-1, -1, -1};
  const int in_q_Rank = 3;
  PyArrayObject *capi_in_q_tmp = NULL;
  int capi_in_q_intent = 0;
  PyObject *in_q_capi = Py_None;
  double *in_t = NULL;
  npy_intp in_t_Dims[3] = {-1, -1, -1};
  const int in_t_Rank = 3;
  PyArrayObject *capi_in_t_tmp = NULL;
  int capi_in_t_intent = 0;
  PyObject *in_t_capi = Py_None;
  double *in_p = NULL;
  npy_intp in_p_Dims[3] = {-1, -1, -1};
  const int in_p_Rank = 3;
  PyArrayObject *capi_in_p_tmp = NULL;
  int capi_in_p_intent = 0;
  PyObject *in_p_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *out_val = NULL;
  npy_intp out_val_Dims[3] = {-1, -1, -1};
  const int out_val_Rank = 3;
  PyArrayObject *capi_out_val_tmp = NULL;
  int capi_out_val_intent = 0;
  static char *capi_kwlist[] = {"in_name","in_q","in_t","in_p","k","l","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|OOO:teos_air.liq_ice_air_g",\
    capi_kwlist,&in_name_capi,&in_q_capi,&in_t_capi,&in_p_capi,&k_capi,&l_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_g to C string");
  if (f2py_success) {
  /* Processing variable in_q */
  ;
  capi_in_q_intent |= F2PY_INTENT_IN;
  capi_in_q_tmp = array_from_pyobj(PyArray_DOUBLE,in_q_Dims,in_q_Rank,capi_in_q_intent,in_q_capi);
  if (capi_in_q_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 2nd argument `in_q' of teos_air.liq_ice_air_g to C/Fortran array" );
  } else {
    in_q = (double *)(capi_in_q_tmp->data);

  /* Processing variable k */
  if (k_capi == Py_None) k = shape(in_q,0); else
    f2py_success = int_from_pyobj(&k,k_capi,"teos_air.liq_ice_air_g() 1st keyword (k) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,0)==k,"shape(in_q,0)==k","1st keyword k","liq_ice_air_g:k=%d",k) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(in_q,2); else
    f2py_success = int_from_pyobj(&m,m_capi,"teos_air.liq_ice_air_g() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,2)==m,"shape(in_q,2)==m","3rd keyword m","liq_ice_air_g:m=%d",m) {
  /* Processing variable l */
  if (l_capi == Py_None) l = shape(in_q,1); else
    f2py_success = int_from_pyobj(&l,l_capi,"teos_air.liq_ice_air_g() 2nd keyword (l) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,1)==l,"shape(in_q,1)==l","2nd keyword l","liq_ice_air_g:l=%d",l) {
  /* Processing variable in_t */
  in_t_Dims[0]=k,in_t_Dims[1]=l,in_t_Dims[2]=m;
  capi_in_t_intent |= F2PY_INTENT_IN;
  capi_in_t_tmp = array_from_pyobj(PyArray_DOUBLE,in_t_Dims,in_t_Rank,capi_in_t_intent,in_t_capi);
  if (capi_in_t_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 3rd argument `in_t' of teos_air.liq_ice_air_g to C/Fortran array" );
  } else {
    in_t = (double *)(capi_in_t_tmp->data);

  /* Processing variable in_p */
  in_p_Dims[0]=k,in_p_Dims[1]=l,in_p_Dims[2]=m;
  capi_in_p_intent |= F2PY_INTENT_IN;
  capi_in_p_tmp = array_from_pyobj(PyArray_DOUBLE,in_p_Dims,in_p_Rank,capi_in_p_intent,in_p_capi);
  if (capi_in_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 4th argument `in_p' of teos_air.liq_ice_air_g to C/Fortran array" );
  } else {
    in_p = (double *)(capi_in_p_tmp->data);

  /* Processing variable out_val */
  out_val_Dims[0]=k,out_val_Dims[1]=l,out_val_Dims[2]=m;
  capi_out_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_out_val_tmp = array_from_pyobj(PyArray_DOUBLE,out_val_Dims,out_val_Rank,capi_out_val_intent,Py_None);
  if (capi_out_val_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting hidden `out_val' of teos_air.liq_ice_air_g to C/Fortran array" );
  } else {
    out_val = (double *)(capi_out_val_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,in_q,in_t,in_p,&k,&l,&m,out_val,slen(in_name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_out_val_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_out_val_tmp == NULL) ... else of out_val*/
  /* End of cleaning variable out_val */
  if((PyObject *)capi_in_p_tmp!=in_p_capi) {
    Py_XDECREF(capi_in_p_tmp); }
  }  /*if (capi_in_p_tmp == NULL) ... else of in_p*/
  /* End of cleaning variable in_p */
  if((PyObject *)capi_in_t_tmp!=in_t_capi) {
    Py_XDECREF(capi_in_t_tmp); }
  }  /*if (capi_in_t_tmp == NULL) ... else of in_t*/
  /* End of cleaning variable in_t */
  } /*CHECKSCALAR(shape(in_q,1)==l)*/
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*CHECKSCALAR(shape(in_q,2)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(in_q,0)==k)*/
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_in_q_tmp!=in_q_capi) {
    Py_XDECREF(capi_in_q_tmp); }
  }  /*if (capi_in_q_tmp == NULL) ... else of in_q*/
  /* End of cleaning variable in_q */
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of liq_ice_air_g ****************************/

/***************************** liq_ice_air_h_desc *****************************/
static char doc_f2py_rout_teos_air_liq_ice_air_h_desc[] = "\
Function signature:\n\
  description = liq_ice_air_h_desc(in_name)\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"Return objects:\n"
"  description : string(len=1000)";
/* extern void F_FUNC_US(liq_ice_air_h_desc,LIQ_ICE_AIR_H_DESC)(string,string,size_t,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_h_desc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  string description = NULL;
  int slen(description);
  PyObject *description_capi = Py_None;
  static char *capi_kwlist[] = {"in_name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:teos_air.liq_ice_air_h_desc",\
    capi_kwlist,&in_name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable description */
  slen(description) = 1000;
  f2py_success = string_from_pyobj(&description,&slen(description),"",description_capi,"string_from_pyobj failed in converting hidden `description' of teos_air.liq_ice_air_h_desc to C string");
  if (f2py_success) {
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_h_desc to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,description,slen(in_name),slen(description));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("z",description);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
    STRINGFREE(description);
  }  /*if (f2py_success) of description*/
  /* End of cleaning variable description */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of liq_ice_air_h_desc *************************/

/******************************* liq_ice_air_h *******************************/
static char doc_f2py_rout_teos_air_liq_ice_air_h[] = "\
Function signature:\n\
  out_val = liq_ice_air_h(in_name,in_q,in_s,in_p,[k,l,m])\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"  in_q : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_s : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_p : input rank-3 array('d') with bounds (k,l,m)\n"
"Optional arguments:\n"
"  k := shape(in_q,0) input int\n"
"  l := shape(in_q,1) input int\n"
"  m := shape(in_q,2) input int\n"
"Return objects:\n"
"  out_val : rank-3 array('d') with bounds (k,l,m)";
/* extern void F_FUNC_US(liq_ice_air_h,LIQ_ICE_AIR_H)(string,double*,double*,double*,int*,int*,int*,double*,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_h(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,double*,int*,int*,int*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  double *in_q = NULL;
  npy_intp in_q_Dims[3] = {-1, -1, -1};
  const int in_q_Rank = 3;
  PyArrayObject *capi_in_q_tmp = NULL;
  int capi_in_q_intent = 0;
  PyObject *in_q_capi = Py_None;
  double *in_s = NULL;
  npy_intp in_s_Dims[3] = {-1, -1, -1};
  const int in_s_Rank = 3;
  PyArrayObject *capi_in_s_tmp = NULL;
  int capi_in_s_intent = 0;
  PyObject *in_s_capi = Py_None;
  double *in_p = NULL;
  npy_intp in_p_Dims[3] = {-1, -1, -1};
  const int in_p_Rank = 3;
  PyArrayObject *capi_in_p_tmp = NULL;
  int capi_in_p_intent = 0;
  PyObject *in_p_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *out_val = NULL;
  npy_intp out_val_Dims[3] = {-1, -1, -1};
  const int out_val_Rank = 3;
  PyArrayObject *capi_out_val_tmp = NULL;
  int capi_out_val_intent = 0;
  static char *capi_kwlist[] = {"in_name","in_q","in_s","in_p","k","l","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|OOO:teos_air.liq_ice_air_h",\
    capi_kwlist,&in_name_capi,&in_q_capi,&in_s_capi,&in_p_capi,&k_capi,&l_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_h to C string");
  if (f2py_success) {
  /* Processing variable in_q */
  ;
  capi_in_q_intent |= F2PY_INTENT_IN;
  capi_in_q_tmp = array_from_pyobj(PyArray_DOUBLE,in_q_Dims,in_q_Rank,capi_in_q_intent,in_q_capi);
  if (capi_in_q_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 2nd argument `in_q' of teos_air.liq_ice_air_h to C/Fortran array" );
  } else {
    in_q = (double *)(capi_in_q_tmp->data);

  /* Processing variable k */
  if (k_capi == Py_None) k = shape(in_q,0); else
    f2py_success = int_from_pyobj(&k,k_capi,"teos_air.liq_ice_air_h() 1st keyword (k) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,0)==k,"shape(in_q,0)==k","1st keyword k","liq_ice_air_h:k=%d",k) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(in_q,2); else
    f2py_success = int_from_pyobj(&m,m_capi,"teos_air.liq_ice_air_h() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,2)==m,"shape(in_q,2)==m","3rd keyword m","liq_ice_air_h:m=%d",m) {
  /* Processing variable l */
  if (l_capi == Py_None) l = shape(in_q,1); else
    f2py_success = int_from_pyobj(&l,l_capi,"teos_air.liq_ice_air_h() 2nd keyword (l) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,1)==l,"shape(in_q,1)==l","2nd keyword l","liq_ice_air_h:l=%d",l) {
  /* Processing variable in_p */
  in_p_Dims[0]=k,in_p_Dims[1]=l,in_p_Dims[2]=m;
  capi_in_p_intent |= F2PY_INTENT_IN;
  capi_in_p_tmp = array_from_pyobj(PyArray_DOUBLE,in_p_Dims,in_p_Rank,capi_in_p_intent,in_p_capi);
  if (capi_in_p_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 4th argument `in_p' of teos_air.liq_ice_air_h to C/Fortran array" );
  } else {
    in_p = (double *)(capi_in_p_tmp->data);

  /* Processing variable in_s */
  in_s_Dims[0]=k,in_s_Dims[1]=l,in_s_Dims[2]=m;
  capi_in_s_intent |= F2PY_INTENT_IN;
  capi_in_s_tmp = array_from_pyobj(PyArray_DOUBLE,in_s_Dims,in_s_Rank,capi_in_s_intent,in_s_capi);
  if (capi_in_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 3rd argument `in_s' of teos_air.liq_ice_air_h to C/Fortran array" );
  } else {
    in_s = (double *)(capi_in_s_tmp->data);

  /* Processing variable out_val */
  out_val_Dims[0]=k,out_val_Dims[1]=l,out_val_Dims[2]=m;
  capi_out_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_out_val_tmp = array_from_pyobj(PyArray_DOUBLE,out_val_Dims,out_val_Rank,capi_out_val_intent,Py_None);
  if (capi_out_val_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting hidden `out_val' of teos_air.liq_ice_air_h to C/Fortran array" );
  } else {
    out_val = (double *)(capi_out_val_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,in_q,in_s,in_p,&k,&l,&m,out_val,slen(in_name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_out_val_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_out_val_tmp == NULL) ... else of out_val*/
  /* End of cleaning variable out_val */
  if((PyObject *)capi_in_s_tmp!=in_s_capi) {
    Py_XDECREF(capi_in_s_tmp); }
  }  /*if (capi_in_s_tmp == NULL) ... else of in_s*/
  /* End of cleaning variable in_s */
  if((PyObject *)capi_in_p_tmp!=in_p_capi) {
    Py_XDECREF(capi_in_p_tmp); }
  }  /*if (capi_in_p_tmp == NULL) ... else of in_p*/
  /* End of cleaning variable in_p */
  } /*CHECKSCALAR(shape(in_q,1)==l)*/
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*CHECKSCALAR(shape(in_q,2)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(in_q,0)==k)*/
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
  if((PyObject *)capi_in_q_tmp!=in_q_capi) {
    Py_XDECREF(capi_in_q_tmp); }
  }  /*if (capi_in_q_tmp == NULL) ... else of in_q*/
  /* End of cleaning variable in_q */
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/**************************** end of liq_ice_air_h ****************************/

/**************************** liq_ice_air_il_desc ****************************/
static char doc_f2py_rout_teos_air_liq_ice_air_il_desc[] = "\
Function signature:\n\
  description = liq_ice_air_il_desc(in_name)\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"Return objects:\n"
"  description : string(len=1000)";
/* extern void F_FUNC_US(liq_ice_air_il_desc,LIQ_ICE_AIR_IL_DESC)(string,string,size_t,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_il_desc(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,string,size_t,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  string description = NULL;
  int slen(description);
  PyObject *description_capi = Py_None;
  static char *capi_kwlist[] = {"in_name",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:teos_air.liq_ice_air_il_desc",\
    capi_kwlist,&in_name_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable description */
  slen(description) = 1000;
  f2py_success = string_from_pyobj(&description,&slen(description),"",description_capi,"string_from_pyobj failed in converting hidden `description' of teos_air.liq_ice_air_il_desc to C string");
  if (f2py_success) {
  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_il_desc to C string");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,description,slen(in_name),slen(description));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("z",description);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
    STRINGFREE(description);
  }  /*if (f2py_success) of description*/
  /* End of cleaning variable description */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of liq_ice_air_il_desc *************************/

/******************************* liq_ice_air_il *******************************/
static char doc_f2py_rout_teos_air_liq_ice_air_il[] = "\
Function signature:\n\
  out_val = liq_ice_air_il(in_name,in_q,in_s,[k,l,m])\n\
Required arguments:\n"
"  in_name : input string(len=-1)\n"
"  in_q : input rank-3 array('d') with bounds (k,l,m)\n"
"  in_s : input rank-3 array('d') with bounds (k,l,m)\n"
"Optional arguments:\n"
"  k := shape(in_q,0) input int\n"
"  l := shape(in_q,1) input int\n"
"  m := shape(in_q,2) input int\n"
"Return objects:\n"
"  out_val : rank-3 array('d') with bounds (k,l,m)";
/* extern void F_FUNC_US(liq_ice_air_il,LIQ_ICE_AIR_IL)(string,double*,double*,int*,int*,int*,double*,size_t); */
static PyObject *f2py_rout_teos_air_liq_ice_air_il(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(string,double*,double*,int*,int*,int*,double*,size_t)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  string in_name = NULL;
  int slen(in_name);
  PyObject *in_name_capi = Py_None;
  double *in_q = NULL;
  npy_intp in_q_Dims[3] = {-1, -1, -1};
  const int in_q_Rank = 3;
  PyArrayObject *capi_in_q_tmp = NULL;
  int capi_in_q_intent = 0;
  PyObject *in_q_capi = Py_None;
  double *in_s = NULL;
  npy_intp in_s_Dims[3] = {-1, -1, -1};
  const int in_s_Rank = 3;
  PyArrayObject *capi_in_s_tmp = NULL;
  int capi_in_s_intent = 0;
  PyObject *in_s_capi = Py_None;
  int k = 0;
  PyObject *k_capi = Py_None;
  int l = 0;
  PyObject *l_capi = Py_None;
  int m = 0;
  PyObject *m_capi = Py_None;
  double *out_val = NULL;
  npy_intp out_val_Dims[3] = {-1, -1, -1};
  const int out_val_Rank = 3;
  PyArrayObject *capi_out_val_tmp = NULL;
  int capi_out_val_intent = 0;
  static char *capi_kwlist[] = {"in_name","in_q","in_s","k","l","m",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOO|OOO:teos_air.liq_ice_air_il",\
    capi_kwlist,&in_name_capi,&in_q_capi,&in_s_capi,&k_capi,&l_capi,&m_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable in_q */
  ;
  capi_in_q_intent |= F2PY_INTENT_IN;
  capi_in_q_tmp = array_from_pyobj(PyArray_DOUBLE,in_q_Dims,in_q_Rank,capi_in_q_intent,in_q_capi);
  if (capi_in_q_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 2nd argument `in_q' of teos_air.liq_ice_air_il to C/Fortran array" );
  } else {
    in_q = (double *)(capi_in_q_tmp->data);

  /* Processing variable in_name */
  slen(in_name) = -1;
  f2py_success = string_from_pyobj(&in_name,&slen(in_name),"",in_name_capi,"string_from_pyobj failed in converting 1st argument `in_name' of teos_air.liq_ice_air_il to C string");
  if (f2py_success) {
  /* Processing variable k */
  if (k_capi == Py_None) k = shape(in_q,0); else
    f2py_success = int_from_pyobj(&k,k_capi,"teos_air.liq_ice_air_il() 1st keyword (k) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,0)==k,"shape(in_q,0)==k","1st keyword k","liq_ice_air_il:k=%d",k) {
  /* Processing variable m */
  if (m_capi == Py_None) m = shape(in_q,2); else
    f2py_success = int_from_pyobj(&m,m_capi,"teos_air.liq_ice_air_il() 3rd keyword (m) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,2)==m,"shape(in_q,2)==m","3rd keyword m","liq_ice_air_il:m=%d",m) {
  /* Processing variable l */
  if (l_capi == Py_None) l = shape(in_q,1); else
    f2py_success = int_from_pyobj(&l,l_capi,"teos_air.liq_ice_air_il() 2nd keyword (l) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(in_q,1)==l,"shape(in_q,1)==l","2nd keyword l","liq_ice_air_il:l=%d",l) {
  /* Processing variable out_val */
  out_val_Dims[0]=k,out_val_Dims[1]=l,out_val_Dims[2]=m;
  capi_out_val_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_out_val_tmp = array_from_pyobj(PyArray_DOUBLE,out_val_Dims,out_val_Rank,capi_out_val_intent,Py_None);
  if (capi_out_val_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting hidden `out_val' of teos_air.liq_ice_air_il to C/Fortran array" );
  } else {
    out_val = (double *)(capi_out_val_tmp->data);

  /* Processing variable in_s */
  in_s_Dims[0]=k,in_s_Dims[1]=l,in_s_Dims[2]=m;
  capi_in_s_intent |= F2PY_INTENT_IN;
  capi_in_s_tmp = array_from_pyobj(PyArray_DOUBLE,in_s_Dims,in_s_Rank,capi_in_s_intent,in_s_capi);
  if (capi_in_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(teos_air_error,"failed in converting 3rd argument `in_s' of teos_air.liq_ice_air_il to C/Fortran array" );
  } else {
    in_s = (double *)(capi_in_s_tmp->data);

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(in_name,in_q,in_s,&k,&l,&m,out_val,slen(in_name));
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_out_val_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_in_s_tmp!=in_s_capi) {
    Py_XDECREF(capi_in_s_tmp); }
  }  /*if (capi_in_s_tmp == NULL) ... else of in_s*/
  /* End of cleaning variable in_s */
  }  /*if (capi_out_val_tmp == NULL) ... else of out_val*/
  /* End of cleaning variable out_val */
  } /*CHECKSCALAR(shape(in_q,1)==l)*/
  } /*if (f2py_success) of l*/
  /* End of cleaning variable l */
  } /*CHECKSCALAR(shape(in_q,2)==m)*/
  } /*if (f2py_success) of m*/
  /* End of cleaning variable m */
  } /*CHECKSCALAR(shape(in_q,0)==k)*/
  } /*if (f2py_success) of k*/
  /* End of cleaning variable k */
    STRINGFREE(in_name);
  }  /*if (f2py_success) of in_name*/
  /* End of cleaning variable in_name */
  if((PyObject *)capi_in_q_tmp!=in_q_capi) {
    Py_XDECREF(capi_in_q_tmp); }
  }  /*if (capi_in_q_tmp == NULL) ... else of in_q*/
  /* End of cleaning variable in_q */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*************************** end of liq_ice_air_il ***************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"liq_ice_air_sat_desc",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_sat_desc,LIQ_ICE_AIR_SAT_DESC),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_sat_desc,doc_f2py_rout_teos_air_liq_ice_air_sat_desc},
  {"liq_ice_air_sat",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_sat,LIQ_ICE_AIR_SAT),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_sat,doc_f2py_rout_teos_air_liq_ice_air_sat},
  {"liq_ice_air_g_ref_desc",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_g_ref_desc,LIQ_ICE_AIR_G_REF_DESC),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_g_ref_desc,doc_f2py_rout_teos_air_liq_ice_air_g_ref_desc},
  {"liq_ice_air_g_ref",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_g_ref,LIQ_ICE_AIR_G_REF),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_g_ref,doc_f2py_rout_teos_air_liq_ice_air_g_ref},
  {"liq_ice_air_g_desc",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_g_desc,LIQ_ICE_AIR_G_DESC),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_g_desc,doc_f2py_rout_teos_air_liq_ice_air_g_desc},
  {"liq_ice_air_g",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_g,LIQ_ICE_AIR_G),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_g,doc_f2py_rout_teos_air_liq_ice_air_g},
  {"liq_ice_air_h_desc",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_h_desc,LIQ_ICE_AIR_H_DESC),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_h_desc,doc_f2py_rout_teos_air_liq_ice_air_h_desc},
  {"liq_ice_air_h",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_h,LIQ_ICE_AIR_H),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_h,doc_f2py_rout_teos_air_liq_ice_air_h},
  {"liq_ice_air_il_desc",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_il_desc,LIQ_ICE_AIR_IL_DESC),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_il_desc,doc_f2py_rout_teos_air_liq_ice_air_il_desc},
  {"liq_ice_air_il",-1,{{-1}},0,(char *)F_FUNC_US(liq_ice_air_il,LIQ_ICE_AIR_IL),(f2py_init_func)f2py_rout_teos_air_liq_ice_air_il,doc_f2py_rout_teos_air_liq_ice_air_il},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "teos_air",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyObject *PyInit_teos_air(void) {
#else
#define RETVAL
PyMODINIT_FUNC initteos_air(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = teos_air_module = PyModule_Create(&moduledef);
#else
  m = teos_air_module = Py_InitModule("teos_air", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module teos_air (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'teos_air' is auto-generated with f2py (version:2).\nFunctions:\n"
"  description = liq_ice_air_sat_desc(in_name)\n"
"  out_val = liq_ice_air_sat(in_name,in_t,in_p,k=shape(in_t,0),l=shape(in_t,1),m=shape(in_t,2))\n"
"  description = liq_ice_air_g_ref_desc(in_name)\n"
"  out_val = liq_ice_air_g_ref(in_name,in_q,in_t,in_p,in_ref,k=shape(in_q,0),l=shape(in_q,1),m=shape(in_q,2))\n"
"  description = liq_ice_air_g_desc(in_name)\n"
"  out_val = liq_ice_air_g(in_name,in_q,in_t,in_p,k=shape(in_q,0),l=shape(in_q,1),m=shape(in_q,2))\n"
"  description = liq_ice_air_h_desc(in_name)\n"
"  out_val = liq_ice_air_h(in_name,in_q,in_s,in_p,k=shape(in_q,0),l=shape(in_q,1),m=shape(in_q,2))\n"
"  description = liq_ice_air_il_desc(in_name)\n"
"  out_val = liq_ice_air_il(in_name,in_q,in_s,k=shape(in_q,0),l=shape(in_q,1),m=shape(in_q,2))\n"
".");
  PyDict_SetItemString(d, "__doc__", s);
  teos_air_error = PyErr_NewException ("teos_air.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));










/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"teos_air");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
