# This Python file uses the following encoding: utf-8
import os

# Utility function to read the README file.
# Used for the long_description.  It's nice, because now 1) we have a top level
# README file and 2) it's easier to type in the README file than to put a raw
# string in below ...
def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

from setuptools import setup, find_packages

#setup(
#    name = "pyteos-air",
#    version = "0.2",
#    packages = find_packages(),
#
#        # metadata for upload to PyPI
#        author = "Frédéric Laliberté",
#        author_email = "frederic.laliberte@utoronto.ca",
#        description = "This package provides python bindings to the atmospheric component of TEOS-10.",
#        license = "BSD",
#        keywords = "thermodynamics atmosphere climate",
#        url = "www.teos-10.org",   # project home page, if any
#        classifiers=[
#            "Development Status :: 4 - Beta",
#            "Intended Audience :: Science/Research",
#            "Natural Language :: English",
#            "License :: OSI Approved :: BSD License",
#            "Programming Language :: Python :: 2.7",
#            "Programming Language :: Fortran",
#            "Topic :: Scientific/Engineering :: Atmospheric Science",
#            "Topic :: Scientific/Engineering :: Mathematics"
#        ],
#        long_description=read('README'),
#        install_requires = ['numpy>=1.6'],
#        zip_safe=False,
#    )


#NEXT, BUILD TEOS-10. IT REQUIRES A SIGNATURE FILE THAT CAN BE GENERATED BY:
#f2py -m teos_air --overwrite-signature -h teos_air.pyf src/teos_air.F90

from numpy.distutils.core import setup, Extension
teos_files=[
'Constants_0.F90',
'Convert_0.F90',
'Maths_0.F90',
'Flu_1.F90',
'Ice_1.F90',
'Sal_1.F90',
'Air_1.F90',
'Flu_2.F90',
'Ice_2.F90',
'Sal_2.F90',
'Air_2.F90',
'Flu_3a.F90',
'Flu_3b.F90',
'Sea_3a.F90',
'Sea_3b.F90',
'Sea_3c.F90',
'Sea_3d.F90',
'Air_3a.F90',
'Air_3b.F90',
'Air_3c.F90',
'Liq_Vap_4.F90',
'Ice_Vap_4.F90',
'Ice_Liq_4.F90',
'Liq_Ice_Air_4.F90',
'Sea_Vap_4.F90',
'Sea_Liq_4.F90',
'Sea_Ice_4.F90',
'Sea_Ice_Vap_4.F90',
'Liq_Air_4a.F90',
'Sea_Air_4.F90',
'Liq_Air_4b.F90',
'Liq_Air_4c.F90',
'Ice_Air_4a.F90',
'Ice_Air_4b.F90',
'Ice_Air_4c.F90',
'Liq_Ice_Air_5.F90',
'Flu_IF97_5.F90',
'Ice_Flu_5.F90',
'Liq_F03_5.F90',
'Sea_5a.F90',
'GSW_Library_5.F90',
'Convert_5.F90',
'Air_5.F90',
'OS2008_5.F90',
]
teos_files=['SIA_library/'+file for file in teos_files]
teos_files.extend(['src/teos_air.F90','teos_air.pyf'])

setup(name='pyteos_air',
    version = "0.2",
    packages = find_packages(),

        # metadata for upload to PyPI
        author = "Frédéric Laliberté",
        author_email = "frederic.laliberte@utoronto.ca",
        description = "This package provides python bindings to the atmospheric component of TEOS-10.",
        license = "BSD",
        keywords = "thermodynamics atmosphere climate",
        url = "www.teos-10.org",   # project home page, if any
        classifiers=[
            "Development Status :: 4 - Beta",
            "Intended Audience :: Science/Research",
            "Natural Language :: English",
            "License :: OSI Approved :: BSD License",
            "Programming Language :: Python :: 2.7",
            "Programming Language :: Fortran",
            "Topic :: Scientific/Engineering :: Atmospheric Science",
            "Topic :: Scientific/Engineering :: Mathematics"
        ],
        long_description=read('README'),
        install_requires = ['numpy>=1.6'],
        zip_safe=False,
        ext_modules = [Extension('teos_air',
                                  teos_files
                                ),
                      ],
    )
