#!/usr/bin/env python
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#
#                               Michael A.G. Aivazis
#                        California Institute of Technology
#                        (C) 1998-2005 All Rights Reserved
#
# <LicenseText>
#
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#

from Element import Element


# the elements

Hydrogen     = Element(  1, "H",  "Hydrogen",       1.00797)
Helium       = Element(  2, "He", "Helium",         4.00260)
Lithium      = Element(  3, "Li", "Lithium",        6.941)
Beryllium    = Element(  4, "Be", "Beryllium",      9.01218)
Boron        = Element(  5, "B",  "Boron",         10.81)
Carbon       = Element(  6, "C",  "Carbon",        12.011)
Nitrogen     = Element(  7, "N",  "Nitrogen",      14.0067)
Oxygen       = Element(  8, "O",  "Oxygen",        15.9994)
Fluorine     = Element(  9, "F",  "Fluorine",      18.9984)
Neon         = Element( 10, "Ne", "Neon",          20.179)
Sodium       = Element( 11, "Na", "Sodium",        22.9898)
Magnesium    = Element( 12, "Mg", "Magnesium",     24.305)
Aluminum     = Element( 13, "Al", "Aluminum",      26.9815)
Silicon      = Element( 14, "Si", "Silicon",       28.0855)
Phosphorus   = Element( 15, "P",  "Phosphorus",    30.9738)
Sulfur       = Element( 16, "S",  "Sulfur",        32.06)
Chlorine     = Element( 17, "Cl", "Chlorine",      35.453)
Argon        = Element( 18, "Ar", "Argon",         39.948)
Potassium    = Element( 19, "K",  "Potassium",     39.0983)
Calcium      = Element( 20, "Ca", "Calcium",       40.08)
Scandium     = Element( 21, "Sc", "Scandium",      44.9559)
Titanium     = Element( 22, "Ti", "Titanium",      47.88)
Vanadium     = Element( 23, "V",  "Vanadium",      50.9415)
Chromium     = Element( 24, "Cr", "Chromium",      51.996)
Manganese    = Element( 25, "Mn", "Manganese",     54.9380)
Iron         = Element( 26, "Fe", "Iron",          55.847)
Cobalt       = Element( 27, "Co", "Cobalt",        58.9332)
Nickel       = Element( 28, "Ni", "Nickel",        58.69)
Copper       = Element( 29, "Cu", "Copper",        63.546)
Zinc         = Element( 30, "Zn", "Zinc",          65.39)
Gallium      = Element( 31, "Ga", "Gallium",       69.72)
Germanium    = Element( 32, "Ge", "Germanium",     72.59)
Arsenic      = Element( 33, "As", "Arsenic",       74.9216)
Selenium     = Element( 34, "Se", "Selenium",      78.96)
Bromine      = Element( 35, "Br", "Bromine",       79.904)
Krypton      = Element( 36, "Kr", "Krypton",       83.80)
Rubidium     = Element( 37, "Rb", "Rubidium",      85.4678)
Strontium    = Element( 38, "Sr", "Strontium",     87.62)
Yttrium      = Element( 39, "Y",  "Yttrium",       88.9059)
Zirconium    = Element( 40, "Zr", "Zirconium",     91.224)
Niobium      = Element( 41, "Nb", "Niobium",       92.9064)
Molybdenum   = Element( 42, "Mo", "Molybdenum",    95.94)
Technetium   = Element( 43, "Tc", "Technetium",    98.)
Ruthenium    = Element( 44, "Ru", "Ruthenium",    101.07)
Rhodium      = Element( 45, "Rh", "Rhodium",      102.906)
Palladium    = Element( 46, "Pd", "Palladium",    106.42)
Silver       = Element( 47, "Ag", "Silver",       107.868)
Cadmium      = Element( 48, "Cd", "Cadmium",      112.41)
Indium       = Element( 49, "In", "Indium",       114.82)
Tin          = Element( 50, "Sn", "Tin",          118.71)
Antimony     = Element( 51, "Sb", "Antimony",     121.75)
Tellurium    = Element( 52, "Te", "Tellurium",    127.60)
Iodine       = Element( 53, "I",  "Iodine",       126.905)
Xenon        = Element( 54, "Xe", "Xenon",        131.29)
Cesium       = Element( 55, "Cs", "Cesium",       132.905)
Barium       = Element( 56, "Ba", "Barium",       137.33)
Lanthanum    = Element( 57, "La", "Lanthanum",    138.906)
Cerium       = Element( 58, "Ce", "Cerium",       140.12)
Praseodymium = Element( 59, "Pr", "Praseodymium", 140.908)
Neodymium    = Element( 60, "Nd", "Neodymium",    144.24)
Promethium   = Element( 61, "Pm", "Promethium",   145.)
Samarium     = Element( 62, "Sm", "Samarium",     150.36)
Europium     = Element( 63, "Eu", "Europium",     151.96)
Gadolinium   = Element( 64, "Gd", "Gadolinium",   157.25)
Terbium      = Element( 65, "Tb", "Terbium",      158.925)
Dysprosium   = Element( 66, "Dy", "Dysprosium",   162.50)
Holmium      = Element( 67, "Ho", "Holmium",      164.930)
Erbium       = Element( 68, "Er", "Erbium",       167.26)
Thulium      = Element( 69, "Tm", "Thulium",      168.934)
Ytterbium    = Element( 70, "Yb", "Ytterbium",    173.04)
Lutetium     = Element( 71, "Lu", "Lutetium",     174.967)
Hafnium      = Element( 72, "Hf", "Hafnium",      178.49)
Tantalum     = Element( 73, "Ta", "Tantalum",     180.948)
Tungsten     = Element( 74, "W",  "Tungsten",     183.85)
Rhenium      = Element( 75, "Re", "Rhenium",      186.207)
Osmium       = Element( 76, "Os", "Osmium",       190.2)
Iridium      = Element( 77, "Ir", "Iridium",      192.22)
Platinum     = Element( 78, "Pt", "Platinum",     195.08)
Gold         = Element( 79, "Au", "Gold",         196.967)
Mercury      = Element( 80, "Hg", "Mercury",      200.59)
Thallium     = Element( 81, "Tl", "Thallium",     204.383)
Lead         = Element( 82, "Pb", "Lead",         207.2)
Bismuth      = Element( 83, "Bi", "Bismuth",      208.980)
Polonium     = Element( 84, "Po", "Polonium",     209.)
Astatine     = Element( 85, "At", "Astatine",     210.)
Radon        = Element( 86, "Rn", "Radon",        222.)
Francium     = Element( 87, "Fr", "Francium",     223.)
Radium       = Element( 88, "Ra", "Radium",       226.025)
Actinium     = Element( 89, "Ac", "Actinium",     227.028)
Thorium      = Element( 90, "Th", "Thorium",      232.038)
Protactinium = Element( 91, "Pa", "Protactinium", 231.036)
Uranium      = Element( 92, "U",  "Uranium",      238.029)
Neptunium    = Element( 93, "Np", "Neptunium",    237.048)
Plutonium    = Element( 94, "Pu", "Plutonium",    244.)
Americium    = Element( 95, "Am", "Americium",    243.)
Curium       = Element( 96, "Cm", "Curium",       247.)
Berkelium    = Element( 97, "Bk", "Berkelium",    247.)
Californium  = Element( 98, "Cf", "Californium",  251.)
Einsteinium  = Element( 99, "Ei", "Einsteinium",  252.)
Fermium      = Element(100, "Fm", "Fermium",      257.)
Mendelevium  = Element(101, "Md", "Mendelevium",  258.)
Nobelium     = Element(102, "No", "Nobelium",     259.)
Lawrencium   = Element(103, "Lw", "Lawrencium",   269.)


# the atomic number index

elements = [
    Hydrogen, Helium, Lithium, Beryllium, Boron, Carbon, Nitrogen, Oxygen,
    Fluorine, Neon, Sodium, Magnesium, Aluminum, Silicon, Phosphorus, Sulfur,
    Chlorine, Argon, Potassium, Calcium, Scandium, Titanium, Vanadium, Chromium,
    Manganese, Iron, Cobalt, Nickel, Copper, Zinc, Gallium, Germanium, Arsenic,
    Selenium, Bromine, Krypton, Rubidium, Strontium, Yttrium, Zirconium, Niobium,
    Molybdenum, Technetium, Ruthenium, Rhodium, Palladium, Silver, Cadmium, Indium,
    Tin, Antimony, Tellurium, Iodine, Xenon, Cesium, Barium, Lanthanum, Cerium,
    Praseodymium, Neodymium, Promethium, Samarium, Europium, Gadolinium, Terbium,
    Dysprosium, Holmium, Erbium, Thulium, Ytterbium, Lutetium, Hafnium, Tantalum,
    Tungsten, Rhenium, Osmium, Iridium, Platinum, Gold, Mercury, Thallium, Lead, Bismuth,
    Polonium, Astatine, Radon, Francium, Radium, Actinium, Thorium, Protactinium,
    Uranium, Neptunium, Plutonium, Americium, Curium, Berkelium, Californium, Einsteinium,
    Fermium, Mendelevium, Nobelium, Lawrencium
    ]


# version
__id__ = "$Id: elements.py,v 1.1.1.1 2005/03/08 16:13:44 aivazis Exp $"

# End of file
