from StringIO import StringIO
from lxml import etree


def remove_namespaces(tree):
        io = StringIO()
        """Remove the namspaces from XML for easier parsing"""
        xslt = """
            <xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
            <xsl:output method="xml" indent="no"/>

            <xsl:template match="/|comment()|processing-instruction()">
                <xsl:copy>
                  <xsl:apply-templates/>
                </xsl:copy>
            </xsl:template>

            <xsl:template match="*">
                <xsl:element name="{local-name()}">
                  <xsl:apply-templates select="@*|node()"/>
                </xsl:element>
            </xsl:template>

            <xsl:template match="@*">
                <xsl:attribute name="{local-name()}">
                  <xsl:value-of select="."/>
                </xsl:attribute>
            </xsl:template>
            </xsl:stylesheet>
        """
        xslt_root = etree.XML(xslt)
        transform = etree.XSLT(xslt_root)
        parsed_tree = transform(tree)
        parsed_tree.write(io)
        return io.getvalue()
