#!/usr/bin/env python3
# -*- mode: python -*-
# -*- coding: utf-8 -*-

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Runs all tests.

Usage:

- Run tests from all modules:
    $ python3 -m base.run_tests discover [-v]

- Run tests in a specific module:
    $ python3 -m run_tests base.test_record [-v]

- Run a specific test:
    $ python3 -m run_tests base.test_record.testRecord [-v]

- Command-line help:
  ./run_tests.py -h
  ./run_tests.py discover -h
"""

import unittest

from base import base

from base.test_base import *
from base.test_command import *
from base.test_record import *

from workflow.test_workflow import *
from workflow.test_task_io import *


def Main(args):
  unittest.main()


if __name__ == '__main__':
  base.Run(Main)
