/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import loci.formats.IFormatHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatHandler
implements IFormatHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormatHandler.class);
    public static final String[] COMPRESSION_SUFFIXES = new String[]{"bz2", "gz"};
    protected String format;
    protected String[] suffixes;
    protected String currentId;

    public FormatHandler(String format, String suffix) {
        String[] stringArray;
        if (suffix == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = suffix;
        }
        this(format, stringArray);
    }

    public FormatHandler(String format, String[] suffixes) {
        this.format = format;
        this.suffixes = suffixes == null ? new String[]{} : suffixes;
    }

    @Override
    public boolean isThisType(String name) {
        return FormatHandler.checkSuffix(name, this.suffixes);
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String[] getSuffixes() {
        return this.suffixes;
    }

    @Override
    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    public static boolean checkSuffix(String name, String suffix) {
        return FormatHandler.checkSuffix(name, new String[]{suffix});
    }

    public static boolean checkSuffix(String name, String[] suffixList) {
        String lname = name.toLowerCase();
        for (int i = 0; i < suffixList.length; ++i) {
            String s = "." + suffixList[i];
            if (lname.endsWith(s)) {
                return true;
            }
            for (int j = 0; j < COMPRESSION_SUFFIXES.length; ++j) {
                if (!lname.endsWith(s + "." + COMPRESSION_SUFFIXES[j])) continue;
                return true;
            }
        }
        return false;
    }
}

