/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.HuffmanCodec;
import loci.formats.codec.HuffmanCodecOptions;

public class LosslessJPEGCodec
extends BaseCodec {
    private static final int SOF0 = 65472;
    private static final int SOF1 = 65473;
    private static final int SOF2 = 65474;
    private static final int SOF3 = 65475;
    private static final int SOF5 = 65477;
    private static final int SOF6 = 65478;
    private static final int SOF7 = 65479;
    private static final int JPG = 65480;
    private static final int SOF9 = 65481;
    private static final int SOF10 = 65482;
    private static final int SOF11 = 65483;
    private static final int SOF13 = 65485;
    private static final int SOF14 = 65486;
    private static final int SOF15 = 65487;
    private static final int DHT = 65476;
    private static final int DAC = 65484;
    private static final int RST_0 = 65488;
    private static final int RST_1 = 65489;
    private static final int RST_2 = 65490;
    private static final int RST_3 = 65491;
    private static final int RST_4 = 65492;
    private static final int RST_5 = 65493;
    private static final int RST_6 = 65494;
    private static final int RST_7 = 65495;
    private static final int SOI = 65496;
    private static final int EOI = 65497;
    private static final int SOS = 65498;
    private static final int DQT = 65499;
    private static final int DNL = 65500;
    private static final int DRI = 65501;
    private static final int DHP = 65502;
    private static final int EXP = 65503;
    private static final int COM = 65534;

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("Lossless JPEG compression not supported");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        int i;
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[] buf = new byte[]{};
        short width = 0;
        short height = 0;
        int bitsPerSample = 0;
        int nComponents = 0;
        int bytesPerSample = 0;
        int[] horizontalSampling = null;
        int[] verticalSampling = null;
        int[] quantizationTable = null;
        Object huffmanTables = null;
        int startPredictor = 0;
        int endPredictor = 0;
        int pointTransform = 0;
        int[] dcTable = null;
        int[] acTable = null;
        while (in.getFilePointer() < in.length() - 1L) {
            int code = in.readShort() & 0xFFFF;
            int length = in.readShort() & 0xFFFF;
            long fp = in.getFilePointer();
            if (length > 65280) {
                length = 0;
                in.seek(fp - 2L);
                continue;
            }
            if (code == 65498) {
                nComponents = in.read();
                dcTable = new int[nComponents];
                acTable = new int[nComponents];
                for (int i2 = 0; i2 < nComponents; ++i2) {
                    int componentSelector = in.read();
                    int tableSelector = in.read();
                    dcTable[i2] = (tableSelector & 0xF0) >> 4;
                    acTable[i2] = tableSelector & 0xF;
                }
                startPredictor = in.read();
                endPredictor = in.read();
                pointTransform = in.read() & 0xF;
                byte[] toDecode = new byte[(int)(in.length() - in.getFilePointer())];
                in.read(toDecode);
                ByteVector b = new ByteVector();
                for (int i3 = 0; i3 < toDecode.length; ++i3) {
                    b.add(toDecode[i3]);
                    if (toDecode[i3] != -1 || toDecode[i3 + 1] != 0) continue;
                    ++i3;
                }
                toDecode = b.toByteArray();
                BitBuffer bb = new BitBuffer(toDecode);
                HuffmanCodec huffman = new HuffmanCodec();
                HuffmanCodecOptions huffmanOptions = new HuffmanCodecOptions();
                huffmanOptions.bitsPerSample = bitsPerSample;
                huffmanOptions.maxBytes = buf.length / nComponents;
                for (int nextSample = 0; nextSample < buf.length / nComponents; nextSample += bytesPerSample) {
                    for (int i4 = 0; i4 < nComponents; ++i4) {
                        int sampleC;
                        huffmanOptions.table = huffmanTables[dcTable[i4]];
                        int v = 0;
                        if (huffmanTables != null) {
                            v = huffman.getSample(bb, huffmanOptions);
                            if (nextSample == 0) {
                                v += (int)Math.pow(2.0, bitsPerSample - 1);
                            }
                        } else {
                            throw new FormatException("Arithmetic coding not supported");
                        }
                        int predictor = startPredictor;
                        if (nextSample < width * bytesPerSample) {
                            predictor = 1;
                        } else if (nextSample % (width * bytesPerSample) == 0) {
                            predictor = 2;
                        }
                        int componentOffset = i4 * (buf.length / nComponents);
                        int indexA = nextSample - bytesPerSample + componentOffset;
                        int indexB = nextSample - width * bytesPerSample + componentOffset;
                        int indexC = nextSample - (width + 1) * bytesPerSample + componentOffset;
                        int sampleA = indexA < 0 ? 0 : DataTools.bytesToInt(buf, indexA, bytesPerSample, false);
                        int sampleB = indexB < 0 ? 0 : DataTools.bytesToInt(buf, indexB, bytesPerSample, false);
                        int n = sampleC = indexC < 0 ? 0 : DataTools.bytesToInt(buf, indexC, bytesPerSample, false);
                        if (nextSample > 0) {
                            int pred = 0;
                            switch (predictor) {
                                case 1: {
                                    pred = sampleA;
                                    break;
                                }
                                case 2: {
                                    pred = sampleB;
                                    break;
                                }
                                case 3: {
                                    pred = sampleC;
                                    break;
                                }
                                case 4: {
                                    pred = sampleA + sampleB + sampleC;
                                    break;
                                }
                                case 5: {
                                    pred = sampleA + (sampleB - sampleC) / 2;
                                    break;
                                }
                                case 6: {
                                    pred = sampleB + (sampleA - sampleC) / 2;
                                    break;
                                }
                                case 7: {
                                    pred = (sampleA + sampleB) / 2;
                                }
                            }
                            v += pred;
                        }
                        int offset = componentOffset + nextSample;
                        DataTools.unpackBytes(v, buf, offset, bytesPerSample, false);
                    }
                }
                continue;
            }
            if ((length -= 2) == 0) continue;
            if (code != 65497) {
                if (code == 65475) {
                    bitsPerSample = in.read();
                    height = in.readShort();
                    width = in.readShort();
                    nComponents = in.read();
                    horizontalSampling = new int[nComponents];
                    verticalSampling = new int[nComponents];
                    quantizationTable = new int[nComponents];
                    for (int i5 = 0; i5 < nComponents; ++i5) {
                        in.skipBytes(1);
                        int s = in.read();
                        horizontalSampling[i5] = (s & 0xF0) >> 4;
                        verticalSampling[i5] = s & 0xF;
                        quantizationTable[i5] = in.read();
                    }
                    bytesPerSample = bitsPerSample / 8;
                    if (bitsPerSample % 8 != 0) {
                        ++bytesPerSample;
                    }
                    buf = new byte[width * height * nComponents * bytesPerSample];
                } else {
                    if (code == 65483) {
                        throw new FormatException("Arithmetic coding is not yet supported");
                    }
                    if (code == 65476) {
                        int i6;
                        if (huffmanTables == null) {
                            huffmanTables = new short[4][];
                        }
                        int s = in.read();
                        byte tableClass = (byte)((s & 0xF0) >> 4);
                        byte destination = (byte)(s & 0xF);
                        int[] nCodes = new int[16];
                        Vector<Short> table = new Vector<Short>();
                        for (i6 = 0; i6 < nCodes.length; ++i6) {
                            nCodes[i6] = in.read();
                            table.add(new Short((short)nCodes[i6]));
                        }
                        for (i6 = 0; i6 < nCodes.length; ++i6) {
                            for (int j = 0; j < nCodes[i6]; ++j) {
                                table.add(new Short((short)(in.read() & 0xFF)));
                            }
                        }
                        huffmanTables[destination] = new short[table.size()];
                        for (i6 = 0; i6 < huffmanTables[destination].length; ++i6) {
                            huffmanTables[destination][i6] = (Short)table.get(i6);
                        }
                    }
                }
            }
            in.seek(fp + (long)length);
        }
        if (options.interleaved && nComponents > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += nComponents * bytesPerSample) {
                for (int c = 0; c < nComponents; ++c) {
                    int src = c * (buf.length / nComponents) + i / nComponents;
                    int dst = i + c * bytesPerSample;
                    System.arraycopy(buf, src, newBuf, dst, bytesPerSample);
                }
            }
            buf = newBuf;
        }
        if (options.littleEndian && bytesPerSample > 1) {
            byte[] newBuf = new byte[buf.length];
            for (i = 0; i < buf.length; i += bytesPerSample) {
                for (int q = 0; q < bytesPerSample; ++q) {
                    newBuf[i + bytesPerSample - q - 1] = buf[i + q];
                }
            }
            buf = newBuf;
        }
        return buf;
    }
}

