/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class SISReader
extends BaseTiffReader {
    private static final int SIS_TAG = 33560;
    private static final int SIS_INI_TAG = 33471;
    private String imageName;
    private double magnification;
    private String channelName;
    private String cameraName;
    private double physicalSizeX;
    private double physicalSizeY;
    private String acquisitionDate;

    public SISReader() {
        super("Olympus SIS TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.get(33560) != null;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageName = null;
            this.channelName = null;
            this.cameraName = null;
            this.magnification = 0.0;
            this.physicalSizeY = 0.0;
            this.physicalSizeX = 0.0;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int t;
        int c;
        IniParser parser;
        IniList ini;
        IniTable dimensions;
        int z;
        super.initStandardMetadata();
        IFD ifd = (IFD)this.ifds.get(0);
        String iniMetadata = ifd.getIFDTextValue(33471);
        if (iniMetadata != null && (z = Integer.parseInt((String)(dimensions = (ini = (parser = new IniParser()).parseINI(new BufferedReader(new StringReader(iniMetadata)))).getTable("Dimension")).get("Z"))) * (c = Integer.parseInt((String)dimensions.get("Band"))) * (t = Integer.parseInt((String)dimensions.get("Time"))) == this.ifds.size()) {
            this.core[0].sizeZ = z;
            this.core[0].sizeT = t;
            this.core[0].sizeC *= c;
        }
        long metadataPointer = ifd.getIFDLongValue(33560, 0L);
        this.in.seek(metadataPointer);
        this.in.skipBytes(4);
        this.in.skipBytes(6);
        short minute = this.in.readShort();
        short hour = this.in.readShort();
        short day = this.in.readShort();
        int month = this.in.readShort() + 1;
        int year = 1900 + this.in.readShort();
        this.acquisitionDate = year + "-" + month + "-" + day + " " + hour + ":" + minute;
        this.acquisitionDate = DateTools.formatDate(this.acquisitionDate, "yyyy-M-d H:m");
        this.in.skipBytes(6);
        this.imageName = this.in.readCString();
        if (this.in.getFilePointer() % 2L == 1L) {
            this.in.skipBytes(1);
        }
        while (this.in.readShort() != 8) {
        }
        this.in.skipBytes(4);
        this.in.seek(this.in.readInt());
        this.in.skipBytes(12);
        this.physicalSizeX = this.in.readDouble();
        this.physicalSizeY = this.in.readDouble();
        this.in.skipBytes(8);
        this.magnification = this.in.readDouble();
        short cameraNameLength = this.in.readShort();
        this.channelName = this.in.readCString();
        int length = Math.min(cameraNameLength, this.channelName.length());
        this.cameraName = this.channelName.substring(0, length);
        this.addGlobalMeta("Nanometers per pixel (X)", this.physicalSizeX);
        this.addGlobalMeta("Nanometers per pixel (Y)", this.physicalSizeY);
        this.addGlobalMeta("Magnification", this.magnification);
        this.addGlobalMeta("Channel name", this.channelName);
        this.addGlobalMeta("Camera name", this.cameraName);
        this.addGlobalMeta("Image name", this.imageName);
        this.addGlobalMeta("Acquisition date", this.acquisitionDate);
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(this.imageName, 0);
        store.setImageAcquiredDate(this.acquisitionDate, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            if ((int)this.magnification > 0) {
                store.setObjectiveNominalMagnification(new PositiveInteger((int)this.magnification), 0, 0);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            store.setImageObjectiveSettingsID(objective, 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            store.setDetectorModel(this.cameraName, 0, 0);
            store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            store.setDetectorSettingsID(detector, 0, 0);
            this.physicalSizeX /= 1000.0;
            this.physicalSizeY /= 1000.0;
            if (this.physicalSizeX > 1.0E-6) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.physicalSizeX), 0);
            }
            if (this.physicalSizeY > 1.0E-6) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.physicalSizeY), 0);
            }
            store.setChannelName(this.channelName, 0, 0);
        }
    }
}

