/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.eventfilesystem;

import java.io.IOException;
import java.util.Iterator;
import loci.common.RandomAccessInputStream;
import loci.poi.poifs.eventfilesystem.POIFSReaderEvent;
import loci.poi.poifs.eventfilesystem.POIFSReaderListener;
import loci.poi.poifs.eventfilesystem.POIFSReaderRegistry;
import loci.poi.poifs.filesystem.DocumentInputStream;
import loci.poi.poifs.filesystem.POIFSDocument;
import loci.poi.poifs.filesystem.POIFSDocumentPath;
import loci.poi.poifs.property.DirectoryProperty;
import loci.poi.poifs.property.Property;
import loci.poi.poifs.property.PropertyTable;
import loci.poi.poifs.storage.BlockAllocationTableReader;
import loci.poi.poifs.storage.BlockList;
import loci.poi.poifs.storage.HeaderBlockReader;
import loci.poi.poifs.storage.RawDataBlockList;
import loci.poi.poifs.storage.SmallBlockTableReader;

public class POIFSReader {
    private POIFSReaderRegistry registry = new POIFSReaderRegistry();
    private boolean registryClosed = false;
    private int bigBlockSize;
    private RandomAccessInputStream stream;

    public void read(RandomAccessInputStream stream, int size) throws IOException {
        this.bigBlockSize = size;
        this.registryClosed = true;
        this.stream = stream;
        HeaderBlockReader header_block_reader = new HeaderBlockReader(stream, size);
        RawDataBlockList data_blocks = new RawDataBlockList(stream, size);
        new BlockAllocationTableReader(header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), data_blocks, size);
        PropertyTable properties = new PropertyTable(header_block_reader.getPropertyStart(), data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(data_blocks, properties.getRoot(), header_block_reader.getSBATStart()), data_blocks, properties.getRoot().getChildren(), new POIFSDocumentPath());
    }

    public void registerListener(POIFSReaderListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(listener);
    }

    public void registerListener(POIFSReaderListener listener, String name) {
        this.registerListener(listener, null, name);
    }

    public void registerListener(POIFSReaderListener listener, POIFSDocumentPath path, String name) {
        if (listener == null || name == null || name.length() == 0) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(listener, path == null ? new POIFSDocumentPath() : path, name);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("at least one argument required: input filename(s)");
            System.exit(1);
        }
        for (int j = 0; j < args.length; ++j) {
            POIFSReader reader = new POIFSReader();
            SampleListener listener = new SampleListener();
            reader.registerListener(listener);
            System.out.println("reading " + args[j]);
            RandomAccessInputStream istream = new RandomAccessInputStream(args[j]);
            reader.read(istream, 512);
            istream.close();
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, POIFSDocumentPath path) throws IOException {
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            String name = property.getName();
            if (property.isDirectory()) {
                POIFSDocumentPath new_path = new POIFSDocumentPath(path, new String[]{name});
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_path);
                continue;
            }
            int startBlock = property.getStartBlock();
            Iterator listeners = this.registry.getListeners(path, name);
            if (listeners.hasNext()) {
                int size = property.getSize();
                POIFSDocument document = null;
                document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock), size, this.bigBlockSize) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock), size, this.bigBlockSize);
                while (listeners.hasNext()) {
                    POIFSReaderListener listener = (POIFSReaderListener)listeners.next();
                    listener.processPOIFSReaderEvent(new POIFSReaderEvent(new DocumentInputStream(document, this.stream), path, name));
                }
                continue;
            }
            if (property.shouldUseSmallBlocks()) {
                small_blocks.fetchBlocks(startBlock);
                continue;
            }
            big_blocks.fetchBlocks(startBlock);
        }
    }

    private static class SampleListener
    implements POIFSReaderListener {
        SampleListener() {
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            DocumentInputStream istream = event.getStream();
            POIFSDocumentPath path = event.getPath();
            String name = event.getName();
            try {
                byte[] data = new byte[istream.available()];
                istream.read(data);
                int pathLength = path.length();
                for (int k = 0; k < pathLength; ++k) {
                    System.out.print("/" + path.getComponent(k));
                }
                System.out.println("/" + name + ": " + data.length + " bytes read");
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }
}

