/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;

public class VerticalPerspective
extends AbstractCoordTransBuilder {
    public String getTransformName() {
        return "vertical_perspective";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double earthRadius;
        double north;
        double lon0 = this.readAttributeDouble(ctv, "longitude_of_projection_origin");
        double lat0 = this.readAttributeDouble(ctv, "latitude_of_projection_origin");
        double distance = this.readAttributeDouble(ctv, "height_above_earth");
        if (Double.isNaN(lon0) || Double.isNaN(lat0) || Double.isNaN(distance)) {
            throw new IllegalArgumentException("Vertical Perspective must have longitude_of_projection_origin, latitude_of_projection_origin, height_above_earth attributes");
        }
        double east = this.readAttributeDouble(ctv, "false_easting");
        if (Double.isNaN(east)) {
            east = 0.0;
        }
        if (Double.isNaN(north = this.readAttributeDouble(ctv, "false_northing"))) {
            north = 0.0;
        }
        if (Double.isNaN(earthRadius = this.readAttributeDouble(ctv, "earth_radius"))) {
            earthRadius = Earth.getRadius() / 1000.0;
        }
        VerticalPerspectiveView proj = new VerticalPerspectiveView(lat0, lon0, earthRadius, distance, east, north);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

