/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.IndexIterator;
import ucar.ma2.MAMath;

public class ImageArrayAdapter {
    public static BufferedImage makeGrayscaleImage(Array ma) {
        if (ma.getRank() == 3) {
            ma = ma.reduce();
        }
        if (ma.getRank() == 3) {
            ma = ma.slice(0, 0);
        }
        int h = ma.getShape()[0];
        int w = ma.getShape()[1];
        DataBuffer dataBuffer = ImageArrayAdapter.makeDataBuffer(ma);
        WritableRaster raster = WritableRaster.createInterleavedRaster(dataBuffer, w, h, w, 1, new int[]{0}, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel colorModel = new ComponentColorModel(cs, new int[]{8}, false, false, 1, 0);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private static DataBuffer makeDataBuffer(Array ma) {
        if (ma instanceof ArrayByte) {
            return ImageArrayAdapter.makeByteDataBuffer((ArrayByte)ma);
        }
        int h = ma.getShape()[0];
        int w = ma.getShape()[1];
        double min = MAMath.getMinimum(ma);
        double max = MAMath.getMaximum(ma);
        double scale = max - min;
        if (scale > 0.0) {
            scale = 255.0 / scale;
        }
        IndexIterator ii = ma.getIndexIterator();
        byte[] byteData = new byte[h * w];
        for (int i = 0; i < byteData.length; ++i) {
            double val = ii.getDoubleNext();
            double sval = (val - min) * scale;
            byteData[i] = (byte)sval;
        }
        return new DataBufferByte(byteData, byteData.length);
    }

    private static DataBuffer makeByteDataBuffer(ArrayByte ma) {
        byte[] byteData = (byte[])ma.copyTo1DJavaArray();
        return new DataBufferByte(byteData, byteData.length);
    }

    private static JLabel test() {
        byte[] tmp2 = new byte[576900];
        for (int i = 0; i < tmp2.length; ++i) {
            int row = i / 640;
            int col = i % 640;
            tmp2[i] = (byte)((double)row * 255.0 / 900.0);
        }
        DataBufferByte db = new DataBufferByte(tmp2, tmp2.length);
        WritableRaster raster = WritableRaster.createInterleavedRaster(db, 900, 640, 900, 1, new int[]{0}, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel cm = new ComponentColorModel(cs, new int[]{8}, false, false, 1, 0);
        BufferedImage image = new BufferedImage(cm, raster, true, null);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(Color.red);
        g2d.draw(new Ellipse2D.Float(0.0f, 0.0f, 200.0f, 100.0f));
        g2d.dispose();
        Color transparent = new Color(0, 0, 0, 0);
        g2d.setColor(transparent);
        g2d.setComposite(AlphaComposite.Src);
        g2d.fill(new Rectangle2D.Float(320.0f, 20.0f, 100.0f, 20.0f));
        g2d.dispose();
        return new JLabel(new ImageIcon(image));
    }

    public static void main(String[] args) {
        Array data = Array.factory(Integer.TYPE, new int[]{255, 100});
        int count = 0;
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            int row = count / 100;
            ii.setIntNext(row * 255);
            ++count;
        }
        BufferedImage image = ImageArrayAdapter.makeGrayscaleImage(data);
        WritableRaster raster = image.getRaster();
        DataBuffer ds = raster.getDataBuffer();
        SampleModel sm = raster.getSampleModel();
        System.out.println(" image type = " + image.getType());
        System.out.println(" transfer type = " + sm.getTransferType());
        AffineTransform at = new AffineTransform();
        AffineTransformOp op = new AffineTransformOp(at, 1);
        BufferedImage targetImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
        BufferedImage image2 = op.filter(image, targetImage);
        System.out.println("ok!");
        boolean display = true;
        if (!display) {
            return;
        }
        JFrame frame = new JFrame("Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ImageIcon icon = new ImageIcon(image2);
        JLabel lab = new JLabel(icon);
        JPanel main = new JPanel();
        main.add(lab);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }
}

