/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.hssf.util.CellReference;
import loci.poi.util.BitField;
import loci.poi.util.BitFieldFactory;
import loci.poi.util.LittleEndian;

public class ReferencePtg
extends Ptg {
    private static final int SIZE = 5;
    public static final byte sid = 36;
    private static final int MAX_ROW_NUMBER = 65536;
    private short field_1_row;
    private short field_2_col;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);
    private BitField column = BitFieldFactory.getInstance(16383);

    protected ReferencePtg() {
    }

    public ReferencePtg(String cellref) {
        CellReference c = new CellReference(cellref);
        this.setRow((short)c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
    }

    public ReferencePtg(short row, short column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    public ReferencePtg(RecordInputStream in) {
        this.field_1_row = in.readShort();
        this.field_2_col = in.readShort();
    }

    public String getRefPtgName() {
        return "ReferencePtg";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append(this.getRefPtgName());
        buffer.append("]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumn()).append("\n");
        buffer.append("rowrelative = ").append(this.isRowRelative()).append("\n");
        buffer.append("colrelative = ").append(this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(36 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_row);
        LittleEndian.putShort(array, offset + 3, this.field_2_col);
    }

    public void setRow(short row) {
        this.field_1_row = row;
    }

    public void setRow(int row) {
        if (row < 0 || row >= 65536) {
            throw new IllegalArgumentException("The row number, when specified as an integer, must be between 0 and 65536");
        }
        this.field_1_row = row > Short.MAX_VALUE ? (short)(row - 65536) : (short)row;
    }

    public short getRow() {
        return this.field_1_row;
    }

    public int getRowAsInt() {
        if (this.field_1_row < 0) {
            return this.field_1_row + 65536;
        }
        return this.field_1_row;
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_2_col);
    }

    public void setRowRelative(boolean rel) {
        this.field_2_col = this.rowRelative.setShortBoolean(this.field_2_col, rel);
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_2_col);
    }

    public void setColRelative(boolean rel) {
        this.field_2_col = this.colRelative.setShortBoolean(this.field_2_col, rel);
    }

    public void setColumnRaw(short col) {
        this.field_2_col = col;
    }

    public short getColumnRaw() {
        return this.field_2_col;
    }

    public void setColumn(short col) {
        this.field_2_col = this.column.setShortValue(this.field_2_col, col);
    }

    public short getColumn() {
        return this.column.getShortValue(this.field_2_col);
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(Workbook book) {
        return new CellReference(this.getRowAsInt(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        ReferencePtg ptg = new ReferencePtg();
        ptg.field_1_row = this.field_1_row;
        ptg.field_2_col = this.field_2_col;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

