/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public class SubsetServiceDataset
implements StationObsDataset {
    private static Namespace defNS = null;
    private NetcdfDataset ncd;
    private ArrayList stations = new ArrayList();

    public SubsetServiceDataset(String ncml, String stations) throws IOException {
        this.ncd = NetcdfDataset.openDataset(ncml, false, null);
        this.readStations(stations);
    }

    private void readStations(String stationXML) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(stationXML);
            doc = builder.build(stationXML);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element rootElem = doc.getRootElement();
        List stations = rootElem.getChildren("station", defNS);
        for (int j = 0; j < stations.size(); ++j) {
            StationImpl station = this.readStation((Element)stations.get(j));
            stations.add(station);
        }
    }

    private StationImpl readStation(Element elem) {
        String name = elem.getAttributeValue("name");
        String value = elem.getAttributeValue("value");
        StationImpl station = new StationImpl();
        station.setName(value);
        station.setDescription(name);
        Element locationElem = elem.getChild("location", defNS);
        if (null == locationElem) {
            locationElem = elem.getChild("location3D", defNS);
        }
        this.readLocation(station, locationElem);
        return station;
    }

    private void readLocation(StationImpl s, Element locationElem) {
        if (locationElem == null) {
            return;
        }
        String latitude = locationElem.getAttributeValue("latitude");
        String longitude = locationElem.getAttributeValue("longitude");
        String elevation = locationElem.getAttributeValue("elevation");
        String latitude_units = locationElem.getAttributeValue("latitude_units");
        String longitude_units = locationElem.getAttributeValue("longitude_units");
        String elevation_units = locationElem.getAttributeValue("elevation_units");
        s.setLatitude(Double.parseDouble(latitude));
        s.setLongitude(Double.parseDouble(longitude));
        if (elevation != null) {
            s.setAltitude(Double.parseDouble(elevation));
        }
    }

    public String getTitle() {
        return this.ncd.getTitle();
    }

    public String getDescription() {
        return null;
    }

    public String getLocationURI() {
        return this.ncd.getLocation();
    }

    public Date getStartDate() {
        return null;
    }

    public Date getEndDate() {
        return null;
    }

    public LatLonRect getBoundingBox() {
        return null;
    }

    public List getGlobalAttributes() {
        return this.ncd.getGlobalAttributes();
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ncd.findGlobalAttributeIgnoreCase(name);
    }

    public List getDataVariables() {
        return this.ncd.getVariables();
    }

    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ncd.findVariable(shortName);
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncd;
    }

    public void close() throws IOException {
        this.ncd.close();
    }

    public String getDetailInfo() {
        return null;
    }

    public Class getDataClass() {
        return StationObsDatatype.class;
    }

    public DateUnit getTimeUnits() {
        return null;
    }

    public List getData() throws IOException {
        return this.getData((CancelTask)null);
    }

    public List getData(CancelTask cancel) throws IOException {
        return null;
    }

    public int getDataCount() {
        return 0;
    }

    public List getData(LatLonRect boundingBox) throws IOException {
        return null;
    }

    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return null;
    }

    public List getData(LatLonRect boundingBox, Date start, Date end) throws IOException {
        return null;
    }

    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        return null;
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    public List getStations() throws IOException {
        return null;
    }

    public List getStations(CancelTask cancel) throws IOException {
        return null;
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        return null;
    }

    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return null;
    }

    public Station getStation(String name) {
        return null;
    }

    public int getStationDataCount(Station s) {
        return 0;
    }

    public List getData(Station s) throws IOException {
        return null;
    }

    public List getData(Station s, CancelTask cancel) throws IOException {
        return null;
    }

    public List getData(Station s, Date start, Date end) throws IOException {
        return null;
    }

    public List getData(Station s, Date start, Date end, CancelTask cancel) throws IOException {
        return null;
    }

    public List getData(List stations) throws IOException {
        return null;
    }

    public List getData(List stations, CancelTask cancel) throws IOException {
        return null;
    }

    public List getData(List stations, Date start, Date end) throws IOException {
        return null;
    }

    public List getData(List stations, Date start, Date end, CancelTask cancel) throws IOException {
        return null;
    }

    public DataIterator getDataIterator(Station s) {
        return null;
    }

    public DataIterator getDataIterator(Station s, Date start, Date end) {
        return null;
    }
}

