/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.io.BinaryDataOutput;
import jj2000.j2k.quantization.quantizer.StdQuantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class HeaderEncoder
implements Markers,
StdEntropyCoderOptions {
    private int defimgn;
    private int deftilenr;
    protected int nComp;
    private boolean enJJ2KMarkSeg = true;
    private String otherCOMMarkSeg = null;
    protected ByteArrayOutputStream baos;
    protected DataOutputStream hbuf;
    protected ImgData origSrc;
    protected boolean[] isOrigSig;
    protected PostCompRateAllocator ralloc;
    protected ForwardWT dwt;
    protected Tiler tiler;
    protected ROIScaler roiSc;
    protected J2KImageWriteParamJava wp;

    public HeaderEncoder(ImgData origsrc, boolean[] isorigsig, ForwardWT dwt, Tiler tiler, J2KImageWriteParamJava wp, ROIScaler roiSc, PostCompRateAllocator ralloc) {
        if (origsrc.getNumComps() != isorigsig.length) {
            throw new IllegalArgumentException();
        }
        this.origSrc = origsrc;
        this.isOrigSig = isorigsig;
        this.dwt = dwt;
        this.tiler = tiler;
        this.wp = wp;
        this.roiSc = roiSc;
        this.ralloc = ralloc;
        this.baos = new ByteArrayOutputStream();
        this.hbuf = new DataOutputStream(this.baos);
        this.nComp = origsrc.getNumComps();
    }

    public void reset() {
        this.baos.reset();
        this.hbuf = new DataOutputStream(this.baos);
    }

    protected byte[] getBuffer() {
        return this.baos.toByteArray();
    }

    public int getLength() {
        return this.hbuf.size();
    }

    public void writeTo(BinaryDataOutput out) throws IOException {
        byte[] buf = this.getBuffer();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            out.writeByte(buf[i]);
        }
    }

    protected int getBufferLength() {
        return this.baos.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.getBuffer(), 0, this.getBufferLength());
    }

    private void writeSOC() throws IOException {
        this.hbuf.writeShort(-177);
    }

    private void writeSIZ() throws IOException {
        this.hbuf.writeShort(-175);
        int markSegLen = 38 + 3 * this.nComp;
        this.hbuf.writeShort(markSegLen);
        this.hbuf.writeShort(0);
        this.hbuf.writeInt(this.tiler.getImgWidth() + this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgHeight() + this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getNomTileWidth());
        this.hbuf.writeInt(this.tiler.getNomTileHeight());
        Point torig = this.tiler.getTilingOrigin(null);
        this.hbuf.writeInt(torig.x);
        this.hbuf.writeInt(torig.y);
        this.hbuf.writeShort(this.nComp);
        for (int c = 0; c < this.nComp; ++c) {
            int tmp = this.origSrc.getNomRangeBits(c) - 1;
            this.hbuf.write(tmp |= (this.isOrigSig[c] ? 1 : 0) << 7);
            this.hbuf.write(this.tiler.getCompSubsX(c));
            this.hbuf.write(this.tiler.getCompSubsY(c));
        }
    }

    protected void writeCOD(boolean mh, int tileIdx) throws IOException {
        AnWTFilter[][] filt;
        Progression[] prog;
        int mrl = 0;
        int a = 0;
        int ppx = 0;
        int ppy = 0;
        if (mh) {
            mrl = (Integer)this.wp.getDecompositionLevel().getDefault();
            ppx = this.wp.getPrecinctPartition().getPPX(-1, -1, mrl);
            ppy = this.wp.getPrecinctPartition().getPPY(-1, -1, mrl);
            prog = (Progression[])this.wp.getProgressionType().getDefault();
        } else {
            mrl = (Integer)this.wp.getDecompositionLevel().getTileDef(tileIdx);
            ppx = this.wp.getPrecinctPartition().getPPX(tileIdx, -1, mrl);
            ppy = this.wp.getPrecinctPartition().getPPY(tileIdx, -1, mrl);
            prog = (Progression[])this.wp.getProgressionType().getTileDef(tileIdx);
        }
        boolean precinctPartitionUsed = ppx != 65535 || ppy != 65535;
        if (precinctPartitionUsed) {
            a = mrl + 1;
        }
        this.hbuf.writeShort(-174);
        int markSegLen = 12 + a;
        this.hbuf.writeShort(markSegLen);
        int tmp = 0;
        if (precinctPartitionUsed) {
            tmp = 1;
        }
        if (mh) {
            if (this.wp.getSOP().getDefault().toString().equalsIgnoreCase("true")) {
                tmp |= 2;
            }
        } else if (this.wp.getSOP().getTileDef(tileIdx).toString().equalsIgnoreCase("true")) {
            tmp |= 2;
        }
        if (mh) {
            if (this.wp.getEPH().getDefault().toString().equalsIgnoreCase("true")) {
                tmp |= 4;
            }
        } else if (this.wp.getEPH().getTileDef(tileIdx).toString().equalsIgnoreCase("true")) {
            tmp |= 4;
        }
        if (this.dwt.getCbULX() != 0) {
            tmp |= 8;
        }
        if (this.dwt.getCbULY() != 0) {
            tmp |= 0x10;
        }
        this.hbuf.write(tmp);
        this.hbuf.write(prog[0].type);
        this.hbuf.writeShort(this.ralloc.getNumLayers());
        String str = null;
        str = mh ? (String)this.wp.getComponentTransformation().getDefault() : (String)this.wp.getComponentTransformation().getTileDef(tileIdx);
        if (str.equals("none")) {
            this.hbuf.write(0);
        } else {
            this.hbuf.write(1);
        }
        this.hbuf.write(mrl);
        if (mh) {
            tmp = this.wp.getCodeBlockSize().getCBlkWidth((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.wp.getCodeBlockSize().getCBlkHeight((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        } else {
            tmp = this.wp.getCodeBlockSize().getCBlkWidth((byte)2, tileIdx, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.wp.getCodeBlockSize().getCBlkHeight((byte)2, tileIdx, -1);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        }
        tmp = 0;
        if (mh) {
            if (((String)this.wp.getBypass().getDefault()).equals("true")) {
                tmp |= 1;
            }
            if (((String)this.wp.getResetMQ().getDefault()).equals("true")) {
                tmp |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getDefault()).equals("true")) {
                tmp |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getDefault()).equals("true")) {
                tmp |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getDefault()).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getDefault()).equals("true")) {
                tmp |= 0x20;
            }
        } else {
            if (((String)this.wp.getBypass().getTileDef(tileIdx)).equals("true")) {
                tmp |= 1;
            }
            if (((String)this.wp.getResetMQ().getTileDef(tileIdx)).equals("true")) {
                tmp |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getTileDef(tileIdx)).equals("true")) {
                tmp |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getTileDef(tileIdx)).equals("true")) {
                tmp |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getTileDef(tileIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getTileDef(tileIdx)).equals("true")) {
                tmp |= 0x20;
            }
        }
        this.hbuf.write(tmp);
        if (mh) {
            filt = (AnWTFilter[][])this.wp.getFilters().getDefault();
            this.hbuf.write(filt[0][0].getFilterType());
        } else {
            filt = (AnWTFilter[][])this.wp.getFilters().getTileDef(tileIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        }
        if (precinctPartitionUsed) {
            Vector[] v = null;
            v = mh ? (Vector[])this.wp.getPrecinctPartition().getDefault() : (Vector[])this.wp.getPrecinctPartition().getTileDef(tileIdx);
            for (int r = mrl; r >= 0; --r) {
                tmp = r >= v[1].size() ? ((Integer)v[1].elementAt(v[1].size() - 1)).intValue() : ((Integer)v[1].elementAt(r)).intValue();
                int yExp = MathUtil.log2(tmp) << 4 & 0xF0;
                tmp = r >= v[0].size() ? ((Integer)v[0].elementAt(v[0].size() - 1)).intValue() : ((Integer)v[0].elementAt(r)).intValue();
                int xExp = MathUtil.log2(tmp) & 0xF;
                this.hbuf.write(yExp | xExp);
            }
        }
    }

    protected void writeCOC(boolean mh, int tileIdx, int compIdx) throws IOException {
        AnWTFilter[][] filt;
        Progression[] prog;
        int mrl = 0;
        int a = 0;
        int ppx = 0;
        int ppy = 0;
        if (mh) {
            mrl = (Integer)this.wp.getDecompositionLevel().getCompDef(compIdx);
            ppx = this.wp.getPrecinctPartition().getPPX(-1, compIdx, mrl);
            ppy = this.wp.getPrecinctPartition().getPPY(-1, compIdx, mrl);
            prog = (Progression[])this.wp.getProgressionType().getCompDef(compIdx);
        } else {
            mrl = (Integer)this.wp.getDecompositionLevel().getTileCompVal(tileIdx, compIdx);
            ppx = this.wp.getPrecinctPartition().getPPX(tileIdx, compIdx, mrl);
            ppy = this.wp.getPrecinctPartition().getPPY(tileIdx, compIdx, mrl);
            prog = (Progression[])this.wp.getProgressionType().getTileCompVal(tileIdx, compIdx);
        }
        boolean precinctPartitionUsed = ppx != 65535 || ppy != 65535;
        if (precinctPartitionUsed) {
            a = mrl + 1;
        }
        this.hbuf.writeShort(-173);
        int markSegLen = 8 + (this.nComp < 257 ? 1 : 2) + a;
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        int tmp = 0;
        if (precinctPartitionUsed) {
            tmp = 1;
        }
        this.hbuf.write(tmp);
        this.hbuf.write(mrl);
        if (mh) {
            tmp = this.wp.getCodeBlockSize().getCBlkWidth((byte)1, -1, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.wp.getCodeBlockSize().getCBlkHeight((byte)1, -1, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        } else {
            tmp = this.wp.getCodeBlockSize().getCBlkWidth((byte)3, tileIdx, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
            tmp = this.wp.getCodeBlockSize().getCBlkHeight((byte)3, tileIdx, compIdx);
            this.hbuf.write(MathUtil.log2(tmp) - 2);
        }
        tmp = 0;
        if (mh) {
            if (((String)this.wp.getBypass().getCompDef(compIdx)).equals("true")) {
                tmp |= 1;
            }
            if (((String)this.wp.getResetMQ().getCompDef(compIdx)).equalsIgnoreCase("true")) {
                tmp |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getCompDef(compIdx)).equals("true")) {
                tmp |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getCompDef(compIdx)).equals("true")) {
                tmp |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getCompDef(compIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getCompDef(compIdx)).equals("true")) {
                tmp |= 0x20;
            }
        } else {
            if (((String)this.wp.getBypass().getTileCompVal(tileIdx, compIdx)).equals("true")) {
                tmp |= 1;
            }
            if (((String)this.wp.getResetMQ().getTileCompVal(tileIdx, compIdx)).equals("true")) {
                tmp |= 2;
            }
            if (((String)this.wp.getTerminateOnByte().getTileCompVal(tileIdx, compIdx)).equals("true")) {
                tmp |= 4;
            }
            if (((String)this.wp.getCausalCXInfo().getTileCompVal(tileIdx, compIdx)).equals("true")) {
                tmp |= 8;
            }
            if (((String)this.wp.getMethodForMQTermination().getTileCompVal(tileIdx, compIdx)).equals("predict")) {
                tmp |= 0x10;
            }
            if (((String)this.wp.getCodeSegSymbol().getTileCompVal(tileIdx, compIdx)).equals("true")) {
                tmp |= 0x20;
            }
        }
        this.hbuf.write(tmp);
        if (mh) {
            filt = (AnWTFilter[][])this.wp.getFilters().getCompDef(compIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        } else {
            filt = (AnWTFilter[][])this.wp.getFilters().getTileCompVal(tileIdx, compIdx);
            this.hbuf.write(filt[0][0].getFilterType());
        }
        if (precinctPartitionUsed) {
            Vector[] v = null;
            v = mh ? (Vector[])this.wp.getPrecinctPartition().getCompDef(compIdx) : (Vector[])this.wp.getPrecinctPartition().getTileCompVal(tileIdx, compIdx);
            for (int r = mrl; r >= 0; --r) {
                tmp = r >= v[1].size() ? ((Integer)v[1].elementAt(v[1].size() - 1)).intValue() : ((Integer)v[1].elementAt(r)).intValue();
                int yExp = MathUtil.log2(tmp) << 4 & 0xF0;
                tmp = r >= v[0].size() ? ((Integer)v[0].elementAt(v[0].size() - 1)).intValue() : ((Integer)v[0].elementAt(r)).intValue();
                int xExp = MathUtil.log2(tmp) & 0xF;
                this.hbuf.write(yExp | xExp);
            }
        }
    }

    protected void writeMainQCD() throws IOException {
        int nqcd;
        String qType = (String)this.wp.getQuantizationType().getDefault();
        float baseStep = ((Float)this.wp.getQuantizationStep().getDefault()).floatValue();
        int gb = (Integer)this.wp.getGuardBits().getDefault();
        boolean isDerived = qType.equals("derived");
        boolean isReversible = qType.equals("reversible");
        int mrl = (Integer)this.wp.getDecompositionLevel().getDefault();
        int nt = this.dwt.getNumTiles();
        int nc = this.dwt.getNumComps();
        int[] tcIdx = new int[2];
        boolean notFound = true;
        for (int t = 0; t < nt && notFound; ++t) {
            for (int c = 0; c < nc && notFound; ++c) {
                int tmpI = (Integer)this.wp.getDecompositionLevel().getTileCompVal(t, c);
                String tmpStr = (String)this.wp.getQuantizationType().getTileCompVal(t, c);
                if (tmpI != mrl || !tmpStr.equals(qType)) continue;
                tcIdx[0] = t;
                tcIdx[1] = c;
                notFound = false;
            }
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCD marker segment. You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tcIdx[0], tcIdx[1]);
        this.defimgn = this.dwt.getNomRangeBits(tcIdx[1]);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (qstyle) {
            case 1: {
                nqcd = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcd = 0;
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (SubbandAn csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        ++nqcd;
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (isReversible ? nqcd : 2 * nqcd);
        this.hbuf.writeShort(markSegLen);
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (SubbandAn csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        int tmp = this.defimgn + csb.anGainExp;
                        this.hbuf.write(tmp << 3);
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            case 1: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                SubbandAn sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (SubbandAn csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        float step = baseStep / (csb.l2Norm * (float)(1 << csb.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeMainQCC(int compIdx) throws IOException {
        SubbandAn sb2;
        SubbandAn sb;
        int nqcc;
        int tIdx = 0;
        int imgnr = this.dwt.getNomRangeBits(compIdx);
        String qType = (String)this.wp.getQuantizationType().getCompDef(compIdx);
        float baseStep = ((Float)this.wp.getQuantizationStep().getCompDef(compIdx)).floatValue();
        int gb = (Integer)this.wp.getGuardBits().getCompDef(compIdx);
        boolean isReversible = qType.equals("reversible");
        boolean isDerived = qType.equals("derived");
        int mrl = (Integer)this.wp.getDecompositionLevel().getCompDef(compIdx);
        int nt = this.dwt.getNumTiles();
        int nc = this.dwt.getNumComps();
        boolean notFound = true;
        for (int t = 0; t < nt && notFound; ++t) {
            for (int c = 0; c < nc && notFound; ++c) {
                int tmpI = (Integer)this.wp.getDecompositionLevel().getTileCompVal(t, c);
                String tmpStr = (String)this.wp.getQuantizationType().getTileCompVal(t, c);
                if (tmpI != mrl || !tmpStr.equals(qType)) continue;
                tIdx = t;
                notFound = false;
            }
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in main QCC (c=" + compIdx + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tIdx, compIdx);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (qstyle) {
            case 1: {
                nqcc = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcc = 0;
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                while (sb.resLvl != 0) {
                    sb = sb.subb_LL;
                }
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        ++nqcc;
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (this.nComp < 257 ? 1 : 2) + (isReversible ? nqcc : 2 * nqcc);
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        int tmp = imgnr + sb2.anGainExp;
                        this.hbuf.write(tmp << 3);
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        float step = baseStep / (sb2.l2Norm * (float)(1 << sb2.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCD(int tIdx) throws IOException {
        SubbandAn csb;
        SubbandAn sb;
        int nqcd;
        String qType = (String)this.wp.getQuantizationType().getTileDef(tIdx);
        float baseStep = ((Float)this.wp.getQuantizationStep().getTileDef(tIdx)).floatValue();
        int mrl = (Integer)this.wp.getDecompositionLevel().getTileDef(tIdx);
        int nc = this.dwt.getNumComps();
        boolean notFound = true;
        int compIdx = 0;
        for (int c = 0; c < nc && notFound; ++c) {
            int tmpI = (Integer)this.wp.getDecompositionLevel().getTileCompVal(tIdx, c);
            String tmpStr = (String)this.wp.getQuantizationStep().getTileCompVal(tIdx, c);
            if (tmpI != mrl || !tmpStr.equals(qType)) continue;
            compIdx = c;
            notFound = false;
        }
        if (notFound) {
            throw new Error("Default representative for quantization type  and number of decomposition levels not found  in tile QCD (t=" + tIdx + ") marker segment. " + "You have found a JJ2000 bug.");
        }
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(tIdx, compIdx);
        this.deftilenr = this.dwt.getNomRangeBits(compIdx);
        int gb = (Integer)this.wp.getGuardBits().getTileDef(tIdx);
        boolean isDerived = qType.equals("derived");
        boolean isReversible = qType.equals("reversible");
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-164);
        switch (qstyle) {
            case 1: {
                nqcd = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcd = 0;
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        ++nqcd;
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (isReversible ? nqcd : 2 * nqcd);
        this.hbuf.writeShort(markSegLen);
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        int tmp = this.deftilenr + csb.anGainExp;
                        this.hbuf.write(tmp << 3);
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (csb = sb; csb != null; csb = (SubbandAn)csb.nextSubband()) {
                        float step = baseStep / (csb.l2Norm * (float)(1 << csb.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCC(int t, int compIdx) throws IOException {
        SubbandAn sb2;
        SubbandAn sb;
        int nqcc;
        SubbandAn sbRoot = this.dwt.getAnSubbandTree(t, compIdx);
        int imgnr = this.dwt.getNomRangeBits(compIdx);
        String qType = (String)this.wp.getQuantizationType().getTileCompVal(t, compIdx);
        float baseStep = ((Float)this.wp.getQuantizationStep().getTileCompVal(t, compIdx)).floatValue();
        int gb = (Integer)this.wp.getGuardBits().getTileCompVal(t, compIdx);
        boolean isReversible = qType.equals("reversible");
        boolean isDerived = qType.equals("derived");
        int mrl = (Integer)this.wp.getDecompositionLevel().getTileCompVal(t, compIdx);
        int qstyle = isReversible ? 0 : (isDerived ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (qstyle) {
            case 1: {
                nqcc = 1;
                break;
            }
            case 0: 
            case 2: {
                nqcc = 0;
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                while (sb.resLvl != 0) {
                    sb = sb.subb_LL;
                }
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        ++nqcc;
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        int markSegLen = 3 + (this.nComp < 257 ? 1 : 2) + (isReversible ? nqcc : 2 * nqcc);
        this.hbuf.writeShort(markSegLen);
        if (this.nComp < 257) {
            this.hbuf.write(compIdx);
        } else {
            this.hbuf.writeShort(compIdx);
        }
        this.hbuf.write(qstyle + (gb << 5));
        switch (qstyle) {
            case 0: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        int tmp = imgnr + sb2.anGainExp;
                        this.hbuf.write(tmp << 3);
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            case 1: {
                sb = sbRoot;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                float step = baseStep / (float)(1 << sb.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                break;
            }
            case 2: {
                sb = sbRoot;
                mrl = sb.resLvl;
                sb = (SubbandAn)sb.getSubbandByIdx(0, 0);
                for (int j = 0; j <= mrl; ++j) {
                    for (sb2 = sb; sb2 != null; sb2 = (SubbandAn)sb2.nextSubband()) {
                        float step = baseStep / (sb2.l2Norm * (float)(1 << sb2.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(step));
                    }
                    sb = (SubbandAn)sb.getNextResLevel();
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writePOC(boolean mh, int tileIdx) throws IOException {
        int markSegLen = 0;
        Progression[] prog = null;
        prog = mh ? (Progression[])this.wp.getProgressionType().getDefault() : (Progression[])this.wp.getProgressionType().getTileDef(tileIdx);
        int lenCompField = this.nComp < 257 ? 1 : 2;
        this.hbuf.writeShort(-161);
        int npoc = prog.length;
        markSegLen = 2 + npoc * (1 + lenCompField + 2 + 1 + lenCompField + 1);
        this.hbuf.writeShort(markSegLen);
        for (int i = 0; i < npoc; ++i) {
            this.hbuf.write(prog[i].rs);
            if (lenCompField == 2) {
                this.hbuf.writeShort(prog[i].cs);
            } else {
                this.hbuf.write(prog[i].cs);
            }
            this.hbuf.writeShort(prog[i].lye);
            this.hbuf.write(prog[i].re);
            if (lenCompField == 2) {
                this.hbuf.writeShort(prog[i].ce);
            } else {
                this.hbuf.write(prog[i].ce);
            }
            this.hbuf.write(prog[i].type);
        }
    }

    public void encodeMainHeader() throws IOException {
        int i;
        this.writeSOC();
        this.writeSIZ();
        boolean isEresUsed = ((String)this.wp.getTerminateOnByte().getDefault()).equals("predict");
        this.writeCOD(true, 0);
        for (i = 0; i < this.nComp; ++i) {
            boolean isEresUsedinComp = ((String)this.wp.getTerminateOnByte().getCompDef(i)).equals("predict");
            if (!this.wp.getFilters().isCompSpecified(i) && !this.wp.getDecompositionLevel().isCompSpecified(i) && !this.wp.getBypass().isCompSpecified(i) && !this.wp.getResetMQ().isCompSpecified(i) && !this.wp.getMethodForMQTermination().isCompSpecified(i) && !this.wp.getCodeSegSymbol().isCompSpecified(i) && !this.wp.getCausalCXInfo().isCompSpecified(i) && !this.wp.getPrecinctPartition().isCompSpecified(i) && !this.wp.getCodeBlockSize().isCompSpecified(i) && isEresUsed == isEresUsedinComp) continue;
            this.writeCOC(true, 0, i);
        }
        this.writeMainQCD();
        for (i = 0; i < this.nComp; ++i) {
            if (this.dwt.getNomRangeBits(i) == this.defimgn && !this.wp.getQuantizationType().isCompSpecified(i) && !this.wp.getQuantizationStep().isCompSpecified(i) && !this.wp.getDecompositionLevel().isCompSpecified(i) && !this.wp.getGuardBits().isCompSpecified(i)) continue;
            this.writeMainQCC(i);
        }
        Progression[] prog = (Progression[])this.wp.getProgressionType().getDefault();
        if (prog.length > 1) {
            this.writePOC(true, 0);
        }
        this.writeCOM();
    }

    private void writeCOM() throws IOException {
        if (this.enJJ2KMarkSeg) {
            String str = "Created by: JJ2000 version 4.1";
            this.hbuf.writeShort(-156);
            int markSegLen = 4 + str.length();
            this.hbuf.writeShort(markSegLen);
            this.hbuf.writeShort(1);
            byte[] chars = str.getBytes();
            for (int i = 0; i < chars.length; ++i) {
                this.hbuf.writeByte(chars[i]);
            }
        }
        if (this.otherCOMMarkSeg != null) {
            StringTokenizer stk = new StringTokenizer(this.otherCOMMarkSeg, "#");
            while (stk.hasMoreTokens()) {
                String str = stk.nextToken();
                this.hbuf.writeShort(-156);
                int markSegLen = 4 + str.length();
                this.hbuf.writeShort(markSegLen);
                this.hbuf.writeShort(1);
                byte[] chars = str.getBytes();
                for (int i = 0; i < chars.length; ++i) {
                    this.hbuf.writeByte(chars[i]);
                }
            }
        }
    }

    private void writeRGN(int tIdx) throws IOException {
        for (int i = 0; i < this.nComp; ++i) {
            this.hbuf.writeShort(-162);
            int markSegLen = 4 + (this.nComp < 257 ? 1 : 2);
            this.hbuf.writeShort(markSegLen);
            if (this.nComp < 257) {
                this.hbuf.writeByte(i);
            } else {
                this.hbuf.writeShort(i);
            }
            this.hbuf.writeByte(0);
            this.hbuf.writeByte((Integer)this.wp.getROIs().getTileCompVal(tIdx, i));
        }
    }

    public void encodeTilePartHeader(int tileLength, int tileIdx) throws IOException {
        Progression[] prog;
        Point numTiles = this.ralloc.getNumTiles(null);
        this.ralloc.setTile(tileIdx % numTiles.x, tileIdx / numTiles.x);
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-112);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(10);
        if (tileIdx > 65534) {
            throw new IllegalArgumentException("Trying to write a tile-part header whose tile index is too high");
        }
        this.hbuf.writeByte(tileIdx >> 8);
        this.hbuf.writeByte(tileIdx);
        int tmp = tileLength;
        this.hbuf.writeByte(tmp >> 24);
        this.hbuf.writeByte(tmp >> 16);
        this.hbuf.writeByte(tmp >> 8);
        this.hbuf.writeByte(tmp);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(1);
        boolean isEresUsed = ((String)this.wp.getMethodForMQTermination().getDefault()).equals("predict");
        boolean isEresUsedInTile = ((String)this.wp.getMethodForMQTermination().getTileDef(tileIdx)).equals("predict");
        boolean tileCODwritten = false;
        if (this.wp.getFilters().isTileSpecified(tileIdx) || this.wp.getComponentTransformation().isTileSpecified(tileIdx) || this.wp.getDecompositionLevel().isTileSpecified(tileIdx) || this.wp.getBypass().isTileSpecified(tileIdx) || this.wp.getResetMQ().isTileSpecified(tileIdx) || this.wp.getTerminateOnByte().isTileSpecified(tileIdx) || this.wp.getCausalCXInfo().isTileSpecified(tileIdx) || this.wp.getPrecinctPartition().isTileSpecified(tileIdx) || this.wp.getSOP().isTileSpecified(tileIdx) || this.wp.getCodeSegSymbol().isTileSpecified(tileIdx) || this.wp.getProgressionType().isTileSpecified(tileIdx) || this.wp.getEPH().isTileSpecified(tileIdx) || this.wp.getCodeBlockSize().isTileSpecified(tileIdx) || isEresUsed != isEresUsedInTile) {
            this.writeCOD(false, tileIdx);
            tileCODwritten = true;
        }
        for (int c = 0; c < this.nComp; ++c) {
            boolean isEresUsedInTileComp = ((String)this.wp.getMethodForMQTermination().getTileCompVal(tileIdx, c)).equals("predict");
            if (this.wp.getFilters().isTileCompSpecified(tileIdx, c) || this.wp.getDecompositionLevel().isTileCompSpecified(tileIdx, c) || this.wp.getBypass().isTileCompSpecified(tileIdx, c) || this.wp.getResetMQ().isTileCompSpecified(tileIdx, c) || this.wp.getTerminateOnByte().isTileCompSpecified(tileIdx, c) || this.wp.getCausalCXInfo().isTileCompSpecified(tileIdx, c) || this.wp.getPrecinctPartition().isTileCompSpecified(tileIdx, c) || this.wp.getCodeSegSymbol().isTileCompSpecified(tileIdx, c) || this.wp.getCodeBlockSize().isTileCompSpecified(tileIdx, c) || isEresUsedInTileComp != isEresUsed) {
                this.writeCOC(false, tileIdx, c);
                continue;
            }
            if (!tileCODwritten || !this.wp.getFilters().isCompSpecified(c) && !this.wp.getDecompositionLevel().isCompSpecified(c) && !this.wp.getBypass().isCompSpecified(c) && !this.wp.getResetMQ().isCompSpecified(c) && !this.wp.getTerminateOnByte().isCompSpecified(c) && !this.wp.getCodeSegSymbol().isCompSpecified(c) && !this.wp.getCausalCXInfo().isCompSpecified(c) && !this.wp.getPrecinctPartition().isCompSpecified(c) && !this.wp.getCodeBlockSize().isCompSpecified(c) && (!this.wp.getMethodForMQTermination().isCompSpecified(c) || !((String)this.wp.getMethodForMQTermination().getCompDef(c)).equals("predict"))) continue;
            this.writeCOC(false, tileIdx, c);
        }
        boolean tileQCDwritten = false;
        if (this.wp.getQuantizationType().isTileSpecified(tileIdx) || this.wp.getQuantizationStep().isTileSpecified(tileIdx) || this.wp.getDecompositionLevel().isTileSpecified(tileIdx) || this.wp.getGuardBits().isTileSpecified(tileIdx)) {
            this.writeTileQCD(tileIdx);
            tileQCDwritten = true;
        } else {
            this.deftilenr = this.defimgn;
        }
        for (int c = 0; c < this.nComp; ++c) {
            if (this.dwt.getNomRangeBits(c) != this.deftilenr || this.wp.getQuantizationType().isTileCompSpecified(tileIdx, c) || this.wp.getQuantizationStep().isTileCompSpecified(tileIdx, c) || this.wp.getDecompositionLevel().isTileCompSpecified(tileIdx, c) || this.wp.getGuardBits().isTileCompSpecified(tileIdx, c)) {
                this.writeTileQCC(tileIdx, c);
                continue;
            }
            if (!tileQCDwritten || !this.wp.getQuantizationType().isCompSpecified(c) && !this.wp.getQuantizationStep().isCompSpecified(c) && !this.wp.getDecompositionLevel().isCompSpecified(c) && !this.wp.getGuardBits().isCompSpecified(c)) continue;
            this.writeTileQCC(tileIdx, c);
        }
        if (this.roiSc.useRoi() && !this.roiSc.getBlockAligned()) {
            this.writeRGN(tileIdx);
        }
        if (this.wp.getProgressionType().isTileSpecified(tileIdx) && (prog = (Progression[])this.wp.getProgressionType().getTileDef(tileIdx)).length > 1) {
            this.writePOC(false, tileIdx);
        }
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-109);
    }
}

