/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.Vector;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.CompressionType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.OMEXMLService;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLWriter
extends FormatWriter {
    private Vector<String> xmlFragments;
    private String currentFragment;
    private OMEXMLService service;

    public OMEXMLWriter() {
        super("OME-XML", "ome");
        this.compressionTypes = new String[]{CompressionType.UNCOMPRESSED.getCompression(), CompressionType.ZLIB.getCompression()};
        this.compression = this.compressionTypes[0];
    }

    public void setId(String id) throws FormatException, IOException {
        String xml;
        super.setId(id);
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(OMEXMLService.class);
            xml = this.service.getOMEXML(retrieve);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.loci.wisc.edu/bio-formats/bio-formats-java-library", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.xmlFragments = new Vector();
        this.currentFragment = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLTools.parseXML(xml, (DefaultHandler)new OMEHandler());
        this.xmlFragments.add(this.currentFragment);
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.writeBytes(this.xmlFragments.get(this.xmlFragments.size() - 1));
        }
        super.close();
        this.xmlFragments = null;
        this.service = null;
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("OMEXMLWriter does not yet support saving image tiles.");
        }
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        if (no == 0) {
            this.out.writeBytes(this.xmlFragments.get(this.series));
        }
        String type = retrieve.getPixelsType(this.series).toString();
        int pixelType = FormatTools.pixelTypeFromString(type);
        int bytes = FormatTools.getBytesPerPixel(pixelType);
        int nChannels = this.getSamplesPerPixel();
        int sizeX = (Integer)retrieve.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)retrieve.getPixelsSizeY(this.series).getValue();
        int planeSize = sizeX * sizeY * bytes;
        boolean bigEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0);
        String namespace = "xmlns=\"http://www.openmicroscopy.org/Schemas/BinaryFile/" + this.service.getLatestVersion() + "\"";
        for (int i = 0; i < nChannels; ++i) {
            byte[] b = ImageTools.splitChannels(buf, i, nChannels, bytes, false, this.interleaved);
            byte[] encodedPix = this.compress(b);
            StringBuffer plane = new StringBuffer("\n<BinData ");
            plane.append(namespace);
            plane.append(" Length=\"");
            plane.append(planeSize);
            plane.append("\"");
            plane.append(" BigEndian=\"");
            plane.append(bigEndian);
            plane.append("\"");
            if (this.compression != null && !this.compression.equals("Uncompressed")) {
                plane.append(" Compression=\"");
                plane.append(this.compression);
                plane.append("\"");
            }
            plane.append(">");
            plane.append(new String(encodedPix));
            plane.append("</BinData>");
            this.out.writeBytes(plane.toString());
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        if (codec != null && (codec.equals("J2K") || codec.equals("JPEG"))) {
            return new int[]{0, 1};
        }
        return super.getPixelTypes(codec);
    }

    private byte[] compress(byte[] b) throws FormatException, IOException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        String type = r.getPixelsType(this.series).toString();
        int pixelType = FormatTools.pixelTypeFromString(type);
        int bytes = FormatTools.getBytesPerPixel(pixelType);
        CodecOptions options = new CodecOptions();
        options.width = (Integer)r.getPixelsSizeX(this.series).getValue();
        options.height = (Integer)r.getPixelsSizeY(this.series).getValue();
        options.channels = 1;
        options.interleaved = false;
        options.signed = FormatTools.isSigned(pixelType);
        options.littleEndian = r.getPixelsBinDataBigEndian(this.series, 0) == false;
        options.bitsPerSample = bytes * 8;
        if (this.compression.equals("J2K")) {
            b = new JPEG2000Codec().compress(b, options);
        } else if (this.compression.equals("JPEG")) {
            b = new JPEGCodec().compress(b, options);
        } else if (this.compression.equals("zlib")) {
            b = new ZlibCodec().compress(b, options);
        }
        return new Base64Codec().compress(b, options);
    }

    class OMEHandler
    extends DefaultHandler {
        OMEHandler() {
        }

        public void characters(char[] ch, int start, int length) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + new String(ch, start, length);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            StringBuffer toAppend = new StringBuffer("\n<");
            toAppend.append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                toAppend.append(" ");
                toAppend.append(attributes.getQName(i));
                toAppend.append("=\"");
                toAppend.append(attributes.getValue(i));
                toAppend.append("\"");
            }
            toAppend.append(">");
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + toAppend.toString();
        }

        public void endElement(String uri, String localName, String qName) {
            OMEXMLWriter.this.currentFragment = OMEXMLWriter.this.currentFragment + ("</" + qName + ">");
            if (qName.equals("Channel")) {
                OMEXMLWriter.this.xmlFragments.add(OMEXMLWriter.this.currentFragment);
                OMEXMLWriter.this.currentFragment = "";
            }
        }
    }
}

