/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.cataloggen.config.CatGenConfigMetadataFactory;
import thredds.cataloggen.config.CatalogGenConfig;
import thredds.cataloggen.config.DatasetSource;
import thredds.datatype.DateType;

public class CatalogGen {
    private static Logger log = LoggerFactory.getLogger(CatalogGen.class);
    private InvCatalog catalog = null;
    protected InvCatalogFactory catFactory = null;
    private List catalogRefInfoList = new ArrayList();

    public List getCatalogRefInfoList() {
        return this.catalogRefInfoList;
    }

    public CatalogGen(URL configDocURL) {
        log.debug("CatalogGen(URL): create catalog and CatalogGenConfig converter.");
        this.catFactory = InvCatalogFactory.getDefaultFactory(true);
        this.catFactory.registerMetadataConverter(MetadataType.CATALOG_GEN_CONFIG.toString(), new CatGenConfigMetadataFactory());
        log.debug("CatalogGen(URL): reading the config doc <" + configDocURL.toString() + ">.");
        this.catalog = this.catFactory.readXML(configDocURL.toString());
        log.debug("CatalogGen(URL): done.");
    }

    public CatalogGen(InputStream configDocInputStream, URL configDocURL) {
        log.debug("CatalogGen(InputStream): create catalog and CatalogGenConfig converter.");
        this.catFactory = new InvCatalogFactory("default", true);
        this.catFactory.registerMetadataConverter(MetadataType.CATALOG_GEN_CONFIG.toString(), new CatGenConfigMetadataFactory());
        log.debug("CatalogGen(InputStream): reading the config doc <" + configDocURL.toString() + ">.");
        this.catalog = this.catFactory.readXML(configDocInputStream, URI.create(configDocURL.toExternalForm()));
        log.debug("CatalogGen(InputStream): CatalogGenConfig doc <" + this.catalog.getName() + "> read.");
    }

    public boolean isValid(StringBuffer out) {
        log.debug("isValid(): start");
        return this.catalog.check(out);
    }

    public InvCatalog expand() {
        CatalogGenConfig tmpCgc = null;
        List cgcList = null;
        DatasetSource dss = null;
        List mdataList = this.findCatGenConfigMdata(this.catalog.getDatasets());
        for (int i = 0; i < mdataList.size(); ++i) {
            InvMetadata curMdata = (InvMetadata)mdataList.get(i);
            InvDatasetImpl curParentDataset = (InvDatasetImpl)curMdata.getParentDataset();
            cgcList = (List)curMdata.getContentObject();
            for (int j = 0; j < cgcList.size(); ++j) {
                tmpCgc = (CatalogGenConfig)cgcList.get(j);
                log.debug("expand(): mdata # " + i + " and catGenConfig # " + j + ".");
                dss = tmpCgc.getDatasetSource();
                InvCatalog generatedCat = null;
                try {
                    generatedCat = dss.fullExpand();
                }
                catch (IOException e) {
                    String tmpMsg = "Error: IOException on fullExpand() of DatasetSource <" + dss.getName() + ">: " + e.getMessage();
                    log.error("expand(): " + tmpMsg);
                    curParentDataset.addDataset(new InvDatasetImpl(curParentDataset, tmpMsg));
                    break;
                }
                this.catalogRefInfoList.addAll(dss.getCatalogRefInfoList());
                InvDataset genTopDs = generatedCat.getDatasets().get(0);
                Iterator<Object> it = generatedCat.getServices().iterator();
                while (it.hasNext()) {
                    ((InvCatalogImpl)curParentDataset.getParentCatalog()).addService(it.next());
                }
                for (InvDatasetImpl invDatasetImpl : genTopDs.getDatasets()) {
                    if (invDatasetImpl.hasNestedDatasets()) {
                        ThreddsMetadata tm = new ThreddsMetadata(false);
                        tm.setServiceName(genTopDs.getServiceDefault().getName());
                        InvMetadata md = new InvMetadata(genTopDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
                        invDatasetImpl.getLocalMetadata().addMetadata(md);
                    } else {
                        invDatasetImpl.getLocalMetadata().setServiceName(genTopDs.getServiceDefault().getName());
                    }
                    curParentDataset.addDataset(invDatasetImpl);
                }
                curParentDataset.finish();
            }
            log.debug("expand(): Remove metadata record CGCM(" + i + ").");
            curParentDataset.removeLocalMetadata(curMdata);
        }
        ((InvCatalogImpl)this.catalog).finish();
        return this.catalog;
    }

    public void setCatalogExpiresDate(DateType expiresDate) {
        ((InvCatalogImpl)this.catalog).setExpires(expiresDate);
    }

    public void writeCatalog(String outFileName) throws IOException {
        log.debug("writeCatalog(): writing catalog to " + outFileName + ".");
        String invCatDTD = "http://www.unidata.ucar.edu/projects/THREDDS/xml/InvCatalog.0.6.dtd";
        log.debug("writeCatalog(): set the catalogs DTD (" + invCatDTD + ").");
        if (outFileName == null) {
            log.debug("writeCatalog(): write catalog to System.out.");
            this.catFactory.writeXML((InvCatalogImpl)this.catalog, System.out);
        } else {
            log.debug("writeCatalog(): try writing catalog to the output file (" + outFileName + ").");
            if (!this.catalog.getVersion().equals("1.0")) {
                this.catFactory.writeXML((InvCatalogImpl)this.catalog, outFileName);
            } else {
                InvCatalogFactory10 fac10 = (InvCatalogFactory10)this.catFactory.getCatalogConverter("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
                fac10.setVersion(this.catalog.getVersion());
                BufferedOutputStream osCat = new BufferedOutputStream(new FileOutputStream(outFileName));
                fac10.writeXML((InvCatalogImpl)this.catalog, osCat);
                osCat.close();
            }
            log.debug("writeCatalog(): catalog written to " + outFileName + ".");
        }
    }

    InvCatalog getCatalog() {
        return this.catalog;
    }

    private List findCatGenConfigMdata(List datasets) {
        ArrayList<InvMetadata> mdataList = new ArrayList<InvMetadata>();
        if (datasets == null) {
            return mdataList;
        }
        Iterator it = datasets.iterator();
        InvDataset curDataset = null;
        while (it.hasNext()) {
            curDataset = (InvDataset)it.next();
            ThreddsMetadata tm = ((InvDatasetImpl)curDataset).getLocalMetadata();
            Iterator<InvMetadata> itMdata = tm.getMetadata().iterator();
            InvMetadata curMetadata = null;
            while (itMdata.hasNext()) {
                curMetadata = itMdata.next();
                if (curMetadata.getMetadataType() != null && curMetadata.getMetadataType().equals(MetadataType.CATALOG_GEN_CONFIG.toString())) {
                    mdataList.add(curMetadata);
                    continue;
                }
                if (curMetadata.getNamespaceURI() == null || !curMetadata.getNamespaceURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5")) continue;
                mdataList.add(curMetadata);
            }
            mdataList.addAll(this.findCatGenConfigMdata(curDataset.getDatasets()));
        }
        return mdataList;
    }
}

