/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.ListIterator;

public class ListenerManager {
    private ArrayList listeners = new ArrayList();
    private Method method = null;
    private boolean hasListeners = false;
    private boolean enabled = true;

    public ListenerManager(String listener_class, String event_class, String method_name) {
        try {
            Method lm;
            Class<?> lc = Class.forName(listener_class);
            Class<?> ec = Class.forName(event_class);
            Class[] params = new Class[]{ec};
            this.method = lm = lc.getMethod(method_name, params);
        }
        catch (Exception ee) {
            System.err.println("ListenerManager failed on " + listener_class + "." + method_name + "( " + event_class + " )");
            ee.printStackTrace(System.err);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void addListener(Object l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
            this.hasListeners = true;
        } else {
            System.out.println("ListenerManager already has Listener " + l);
        }
    }

    public synchronized void removeListener(Object l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
            this.hasListeners = this.listeners.size() > 0;
        } else {
            System.out.println("ListenerManager couldnt find Listener " + l);
        }
    }

    public boolean hasListeners() {
        return this.hasListeners;
    }

    public void sendEvent(EventObject event) {
        if (!this.hasListeners || !this.enabled) {
            return;
        }
        Object[] args = new Object[]{event};
        ListIterator iter = this.listeners.listIterator();
        while (iter.hasNext()) {
            Object client = iter.next();
            try {
                this.method.invoke(client, args);
            }
            catch (IllegalAccessException e) {
                iter.remove();
                System.err.println("ListenerManager IllegalAccessException = " + e);
            }
            catch (IllegalArgumentException e) {
                iter.remove();
                System.err.println("ListenerManager IllegalArgumentException = " + e);
            }
            catch (InvocationTargetException e) {
                iter.remove();
                System.err.println("ListenerManager InvocationTargetException on " + this.method);
                System.err.println("   threw exception " + e.getTargetException());
                e.printStackTrace();
            }
        }
    }

    public void sendEventExcludeSource(EventObject event) {
        if (!this.hasListeners || !this.enabled) {
            return;
        }
        Object source = event.getSource();
        Object[] args = new Object[]{event};
        ListIterator iter = this.listeners.listIterator();
        while (iter.hasNext()) {
            Object client = iter.next();
            if (client == source) continue;
            try {
                this.method.invoke(client, args);
            }
            catch (IllegalAccessException e) {
                iter.remove();
                System.err.println("ListenerManager IllegalAccessException = " + e);
            }
            catch (IllegalArgumentException e) {
                iter.remove();
                System.err.println("ListenerManager IllegalArgumentException = " + e);
            }
            catch (InvocationTargetException e) {
                iter.remove();
                System.err.println("ListenerManager InvocationTargetException on " + this.method);
                System.err.println("   threw exception " + e.getTargetException());
                e.printStackTrace();
            }
        }
    }
}

