/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section {
    private List<Range> list;
    private boolean immutable = false;

    public Section(int[] shape) throws InvalidRangeException {
        this.list = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            this.list.add(shape[i] > 0 ? new Range(0, shape[i] - 1) : Range.EMPTY);
        }
    }

    public Section(int[] origin, int[] shape) throws InvalidRangeException {
        this.list = new ArrayList<Range>();
        for (int i = 0; i < shape.length; ++i) {
            this.list.add(shape[i] > 0 ? new Range(origin[i], origin[i] + shape[i] - 1) : Range.EMPTY);
        }
    }

    public Section(int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        this.list = new ArrayList<Range>();
        for (int i = 0; i < size.length; ++i) {
            this.list.add(size[i] > 0 ? new Range(origin[i], origin[i] + size[i] - 1, stride[i]) : Range.EMPTY);
        }
    }

    public Section(List<Range> from) {
        this.list = new ArrayList<Range>(from);
    }

    public Section(Section from) {
        this.list = new ArrayList<Range>(from.getRanges());
    }

    public Section(List<Range> from, int[] shape) throws InvalidRangeException {
        this.list = new ArrayList<Range>(from);
        this.setDefaults(shape);
    }

    public static Section fill(Section s, int[] shape) throws InvalidRangeException {
        if (s == null) {
            return new Section(shape);
        }
        String errs = s.checkInRange(shape);
        if (errs != null) {
            throw new InvalidRangeException(errs);
        }
        boolean ok = true;
        for (int i = 0; i < shape.length; ++i) {
            ok &= s.getRange(i) != null;
        }
        if (ok) {
            return s;
        }
        return new Section(s.getRanges(), shape);
    }

    public Section(String sectionSpec) throws InvalidRangeException {
        this.list = new ArrayList<Range>();
        StringTokenizer stoke = new StringTokenizer(sectionSpec, "(),");
        while (stoke.hasMoreTokens()) {
            Range range;
            String s = stoke.nextToken().trim();
            if (s.equals(":")) {
                range = null;
            } else {
                if (s.indexOf(58) < 0) {
                    try {
                        int index = Integer.parseInt(s);
                        range = new Range(index, index);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                    }
                }
                StringTokenizer stoke2 = new StringTokenizer(s, ":");
                String s1 = stoke2.nextToken();
                String s2 = stoke2.nextToken();
                String s3 = stoke2.hasMoreTokens() ? stoke2.nextToken() : null;
                try {
                    int index1 = Integer.parseInt(s1);
                    int index2 = Integer.parseInt(s2);
                    int stride = s3 != null ? Integer.parseInt(s3) : 1;
                    range = new Range(index1, index2, stride);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + sectionSpec + ">");
                }
            }
            this.list.add(range);
        }
    }

    public Section compact() throws InvalidRangeException {
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (Range r : this.list) {
            results.add(r.compact());
        }
        return new Section(results);
    }

    public Section compose(Section want) throws InvalidRangeException {
        if (want == null) {
            return this;
        }
        if (want.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.list.size(); ++j) {
            Range base = this.list.get(j);
            Range r = want.getRange(j);
            if (r == null) {
                results.add(base);
                continue;
            }
            results.add(base.compose(r));
        }
        return new Section(results);
    }

    public Section intersect(Section other) throws InvalidRangeException {
        if (other.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.list.size(); ++j) {
            Range base = this.list.get(j);
            Range r = other.getRange(j);
            results.add(base.intersect(r));
        }
        return new Section(results);
    }

    public int offset(Section intersect) throws InvalidRangeException {
        if (intersect.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        int result = 0;
        int stride = 1;
        for (int j = this.list.size() - 1; j >= 0; --j) {
            Range base = this.list.get(j);
            Range r = intersect.getRange(j);
            int offset = base.index(r.first());
            result += offset * stride;
            stride *= base.length();
        }
        return result;
    }

    public Section union(Section other) throws InvalidRangeException {
        if (other.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.list.size(); ++j) {
            Range base = this.list.get(j);
            Range r = other.getRange(j);
            results.add(base.union(r));
        }
        return new Section(results);
    }

    public Section shiftOrigin(Section newOrigin) throws InvalidRangeException {
        if (newOrigin.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        ArrayList<Range> results = new ArrayList<Range>(this.getRank());
        for (int j = 0; j < this.list.size(); ++j) {
            Range base = this.list.get(j);
            Range r = newOrigin.getRange(j);
            results.add(base.shiftOrigin(r.first()));
        }
        return new Section(results);
    }

    public boolean intersects(Section other) throws InvalidRangeException {
        if (other.getRank() != this.getRank()) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        for (int j = 0; j < this.list.size(); ++j) {
            Range r;
            Range base = this.list.get(j);
            if (base.intersects(r = other.getRange(j))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            Range r = this.list.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            if (r == null) {
                sbuff.append(":");
                continue;
            }
            sbuff.append(r.toString());
        }
        return sbuff.toString();
    }

    public Section() {
        this.list = new ArrayList<Range>();
    }

    public Section appendRange() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(null);
        return this;
    }

    public Section appendRange(Range r) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(r);
        return this;
    }

    public Section appendRange(int size) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(size > 0 ? new Range(0, size - 1) : Range.EMPTY);
        return this;
    }

    public Section appendRange(int first, int last) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(new Range(first, last));
        return this;
    }

    public Section appendRange(int first, int last, int stride) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(new Range(first, last, stride));
        return this;
    }

    public Section appendRange(String name, int first, int last, int stride) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(new Range(name, first, last, stride));
        return this;
    }

    public Section insertRange(int index, Range r) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.add(index, r);
        return this;
    }

    public Section removeRange(int index) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.remove(index);
        return this;
    }

    public Section setRange(int index, Range r) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.set(index, r);
        return this;
    }

    public Section replaceRange(int index, Range r) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.list.set(index, r);
        return this;
    }

    public void setDefaults(int[] shape) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (shape.length != this.list.size()) {
            throw new InvalidRangeException(" shape[] must have same rank as Section");
        }
        for (int i = 0; i < shape.length; ++i) {
            Range r = this.list.get(i);
            if (r != null) continue;
            this.list.set(i, new Range(0, shape[i] - 1));
        }
    }

    public Section setImmutable() {
        this.immutable = true;
        this.list = Collections.unmodifiableList(this.list);
        return this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int[] getShape() {
        int[] result = new int[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            result[i] = this.list.get(i).length();
        }
        return result;
    }

    public int[] getOrigin() {
        int[] result = new int[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            result[i] = this.list.get(i).first();
        }
        return result;
    }

    public int[] getStride() {
        int[] result = new int[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            result[i] = this.list.get(i).stride();
        }
        return result;
    }

    public int getOrigin(int i) {
        return this.list.get(i).first();
    }

    public int getShape(int i) {
        return this.list.get(i).length();
    }

    public int getStride(int i) {
        return this.list.get(i).stride();
    }

    public int getRank() {
        return this.list.size();
    }

    public long computeSize() {
        return Index.computeSize(this.getShape());
    }

    public List<Range> getRanges() {
        return this.list;
    }

    public Range getRange(int i) {
        return this.list.get(i);
    }

    public Range find(String rangeName) {
        for (Range r : this.list) {
            if (!rangeName.equals(r.getName())) continue;
            return r;
        }
        return null;
    }

    public Section addRangeNames(List<String> rangeNames) throws InvalidRangeException {
        if (rangeNames.size() != this.getRank()) {
            throw new InvalidRangeException("Invalid number of Range Names");
        }
        int count = 0;
        Section result = new Section();
        for (Range r : this.getRanges()) {
            Range nr = new Range(rangeNames.get(count++), r);
            result.appendRange(nr);
        }
        return result;
    }

    public String checkInRange(int[] shape) {
        if (this.list.size() != shape.length) {
            return "Number of ranges in section (" + this.list.size() + ") must be = " + shape.length;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Range r = this.list.get(i);
            if (r == null || r.last() < shape[i]) continue;
            return "Illegal Range for dimension " + i + ": last requested " + r.last() + " > max " + (shape[i] - 1);
        }
        return null;
    }

    public boolean equivalent(int[] shape) throws InvalidRangeException {
        if (this.getRank() != shape.length) {
            throw new InvalidRangeException("Invalid Section rank");
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Range r = this.list.get(i);
            if (r == null) continue;
            if (r.first() != 0) {
                return false;
            }
            if (r.length() == shape[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section os = (Section)o;
        if (this.getRank() != os.getRank()) {
            return false;
        }
        for (int i = 0; i < this.getRank(); ++i) {
            Range r = this.getRange(i);
            Range or = os.getRange(i);
            if (r == null && or != null) {
                return false;
            }
            if (or == null && r != null) {
                return false;
            }
            if (r == null || r.equals(or)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (Range r : this.list) {
            if (r == null) continue;
            result += 37 * result + r.hashCode();
        }
        return result;
    }
}

