/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class StructurePseudo
extends Structure {
    private List<Variable> orgVariables = new ArrayList<Variable>();
    private boolean debugRecord = false;

    public StructurePseudo(NetcdfFile ncfile, Group group, String shortName, Dimension dim) {
        super(ncfile, group, null, shortName);
        this.dataType = DataType.STRUCTURE;
        this.setDimensions(dim.getName());
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        List<Variable> vars = group.getVariables();
        for (Variable orgV : vars) {
            Dimension dim0 = orgV.getDimension(0);
            if (dim0 == null || !dim0.equals(dim)) continue;
            Variable memberV = new Variable(ncfile, group, this, orgV.getName());
            memberV.setDataType(orgV.getDataType());
            memberV.setSPobject(orgV.getSPobject());
            memberV.attributes.addAll(orgV.getAttributes());
            ArrayList<Dimension> dims = new ArrayList<Dimension>(orgV.dimensions);
            dims.remove(0);
            memberV.setDimensions(dims);
            this.addMemberVariable(memberV);
            this.orgVariables.add(orgV);
        }
        this.calcElementSize();
    }

    protected Array _read() throws IOException {
        if (this.debugRecord) {
            System.out.println(" read all psuedo records ");
        }
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, this.getShape());
        for (Variable v : this.orgVariables) {
            Array data = v.read();
            StructureMembers.Member m = smembers.findMember(v.getName());
            m.setDataObject(data);
        }
        return asma;
    }

    protected Array _read(Section section) throws IOException, InvalidRangeException {
        String err;
        if (null == section) {
            return this._read();
        }
        if (this.debugRecord) {
            System.out.println(" read psuedo records " + section.getRange(0));
        }
        if ((err = section.checkInRange(this.getShape())) != null) {
            throw new InvalidRangeException(err);
        }
        Range r = section.getRange(0);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, this.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>(v.getRanges());
            vsection.set(0, r);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getName());
            m.setDataObject(data);
        }
        return asma;
    }

    protected Array _readMemberData(Section section, boolean flatten) throws IOException, InvalidRangeException {
        throw new UnsupportedOperationException();
    }
}

