/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class OceanSigma
extends VerticalTransformImpl {
    public static final String ETA = "Eta_variableName";
    public static final String SIGMA = "Sigma_variableName";
    public static final String DEPTH = "Depth_variableName";
    private Variable etaVar;
    private Variable sVar;
    private Variable depthVar;

    public OceanSigma(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String etaName = vCT.findParameterIgnoreCase(ETA).getStringValue();
        String sName = vCT.findParameterIgnoreCase(SIGMA).getStringValue();
        String depthName = vCT.findParameterIgnoreCase(DEPTH).getStringValue();
        this.etaVar = ds.findStandardVariable(etaName);
        this.sVar = ds.findStandardVariable(sName);
        this.depthVar = ds.findStandardVariable(depthName);
        this.units = ds.findAttValueIgnoreCase(this.depthVar, "units", "none");
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array eta = this.readArray(this.etaVar, timeIndex);
        Array sigma = this.readArray(this.sVar, timeIndex);
        Array depth = this.readArray(this.depthVar, timeIndex);
        int nz = (int)sigma.getSize();
        Index sIndex = sigma.getIndex();
        int[] shape2D = eta.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double sigmaVal = sigma.getDouble(sIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double etaVal = eta.getDouble(etaIndex.set(y, x));
                    double depthVal = depth.getDouble(depthIndex.set(y, x));
                    height.set(z, y, x, etaVal + sigmaVal * (depthVal + etaVal));
                }
            }
        }
        return height;
    }
}

