/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import java.util.HashMap;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.BitWriter;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.HuffmanCodecOptions;

public class HuffmanCodec
extends BaseCodec {
    private static final int LEAVES_OFFSET = 16;
    private int leafCounter;
    private HashMap<short[], Decoder> cachedDecoders = new HashMap();

    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new FormatException("Huffman encoding not currently supported");
    }

    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null || !(options instanceof HuffmanCodecOptions)) {
            throw new FormatException("Options must be an instance of loci.formats.codec.HuffmanCodecOptions.");
        }
        HuffmanCodecOptions huffman = (HuffmanCodecOptions)options;
        byte[] pix = new byte[huffman.maxBytes];
        in.read(pix);
        BitBuffer bb = new BitBuffer(pix);
        int nSamples = huffman.maxBytes * 8 / huffman.bitsPerSample;
        int bytesPerSample = huffman.bitsPerSample / 8;
        if (huffman.bitsPerSample % 8 != 0) {
            ++bytesPerSample;
        }
        BitWriter out = new BitWriter();
        for (int i = 0; i < nSamples; ++i) {
            int sample = this.getSample(bb, options);
            out.write(sample, bytesPerSample * 8);
        }
        return out.toByteArray();
    }

    public int getSample(BitBuffer bb, CodecOptions options) throws FormatException {
        int v;
        int bitCount;
        if (bb == null) {
            throw new IllegalArgumentException("No data to handle.");
        }
        if (options == null || !(options instanceof HuffmanCodecOptions)) {
            throw new FormatException("Options must be an instance of loci.formats.codec.HuffmanCodecOptions.");
        }
        HuffmanCodecOptions huffman = (HuffmanCodecOptions)options;
        Decoder decoder = this.cachedDecoders.get(huffman.table);
        if (decoder == null) {
            decoder = new Decoder(huffman.table);
            this.cachedDecoders.put(huffman.table, decoder);
        }
        if ((bitCount = decoder.decode(bb)) < 0) {
            bitCount = 0;
        }
        if (((v = bb.getBits(bitCount) & (int)Math.pow(2.0, bitCount) - 1) & 1 << bitCount - 1) == 0) {
            v -= (1 << bitCount) - 1;
        }
        return v;
    }

    class Decoder {
        public Decoder[] branch = new Decoder[2];
        private int leafValue = -1;

        public Decoder() {
        }

        public Decoder(short[] source) {
            HuffmanCodec.this.leafCounter = 0;
            this.createDecoder(this, source, 0, 0);
        }

        private Decoder createDecoder(short[] source, int start, int level) {
            Decoder dest = new Decoder();
            this.createDecoder(dest, source, start, level);
            return dest;
        }

        private void createDecoder(Decoder dest, short[] source, int start, int level) {
            int i;
            int next = 0;
            for (i = 0; i <= HuffmanCodec.this.leafCounter && next < 16; i += source[start + next++] & 0xFF) {
            }
            if (level < next && next < 16) {
                dest.branch[0] = this.createDecoder(source, start, level + 1);
                dest.branch[1] = this.createDecoder(source, start, level + 1);
            } else {
                i = start + 16 + HuffmanCodec.this.leafCounter++;
                if (i < source.length) {
                    dest.leafValue = source[i] & 0xFF;
                }
            }
        }

        public int decode(BitBuffer bb) {
            int v;
            Decoder d = this;
            while (d.branch[0] != null && (v = bb.getBits(1)) >= 0) {
                d = d.branch[v];
            }
            return d.leafValue;
        }
    }
}

